(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    834844,      17961]
NotebookOptionsPosition[    815439,      17514]
NotebookOutlinePosition[    816559,      17553]
CellTagsIndexPosition[    816516,      17550]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        SuperscriptBox["a", "2"]}], "=", 
       SuperscriptBox["b", "2"]}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.5047258667134433`*^9, 3.5047259284235296`*^9, {
   3.50472971453883*^9, 3.504729719478837*^9}, {3.5047304814999037`*^9, 
   3.5047304917899184`*^9}, {3.5053445844837046`*^9, 
   3.5053445851537056`*^9}, {3.5100199355257735`*^9, 3.510019945338191*^9}, {
   3.510019976460245*^9, 3.510019976460245*^9}, {3.5101703833552046`*^9, 
   3.5101703833552046`*^9}, {3.5102544956897216`*^9, 
   3.5102544956897216`*^9}, {3.5133761975110507`*^9, 3.5133761975110507`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[Cell[TextData[StyleBox["Domain Map ",
   FontSize->24]], "Title",
   CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
     3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
     3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
   TextAlignment->Center,
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"],
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.5021272389648304`*^9, 3.5021272415948343`*^9}, {3.504490508246251*^9, 
   3.5044905119162564`*^9}, {3.504490558286321*^9, 3.5044905783463497`*^9}, 
   3.5046318639667244`*^9, {3.5133764141713543`*^9, 3.5133764144313545`*^9}, {
   3.5133768494019637`*^9, 3.5133768529319687`*^9}, {3.5133769622021217`*^9, 
   3.5133769624321218`*^9}, 3.5136146877422624`*^9, 3.5136147334191427`*^9, {
   3.5136147801880245`*^9, 3.513614782606029*^9}, {3.513615527689342*^9, 
   3.5136155492953796`*^9}, {3.5138010036163597`*^9, 3.5138010122288523`*^9}, 
   3.5147368623998885`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{-4, 1}, {-1, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1a \[LowerRightArrow]\[DownArrow]\[Diamond]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], 3}, {-2.5, 3}]]}, 
   {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
    LineBox[{{-1.02, 3.98}, {-1.02, 1.02}}], 
    {RGBColor[1., 0.5, 0.5], Dashing[{}], RectangleBox[{-4, 0}, {-1, 1}], 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 1b \[LowerRightArrow]\[Diamond]\"\>",
        StripOnInput->False,
        FontSize->10], {-3.25, 0.5}]}, 
     {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
      LineBox[{{-1.02, 1}, {-1.02, 0}}], 
      {RGBColor[0.7, 0.7, 1.], Dashing[{}], RectangleBox[{-1, 1}, {0, 4}], 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 2\[DownArrow]\[DownArrow]\[Diamond]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[-1, 2], 3}, {-0.5, 3}]]}, 
       {GrayLevel[1], Thickness[Large], 
        LineBox[NCache[{{0, 1}, {Rational[1, 2], Rational[3, 2]}}, {{0, 1}, {
           0.5, 1.5}}]], 
        {RGBColor[0.2, 1., 0.2], RectangleBox[{1, -1}, {4, 4}]}, 
        {GrayLevel[0], InsetBox[
          StyleBox["\<\"Rule 3a \[LeftArrow]\[LeftArrow]\[Diamond]\"\>",
           StripOnInput->False,
           FontSize->10], {3, 3}]}, 
        {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
         LineBox[{{1.02, -0.98}, {3.98, -0.98}}], 
         {RGBColor[0.7, 1., 0.7], Dashing[{}], RectangleBox[{0, 0}, {1, 4}], 
          {GrayLevel[0], InsetBox[
            StyleBox["\<\"Rule 3b\\n\[LowerLeftArrow]  \[Diamond]\"\>",
             StripOnInput->False,
             FontSize->10], NCache[{Rational[1, 2], 3}, {0.5, 3}]]}, 
          {RGBColor[1, 0.5, 0.5], RectangleBox[{1, -1}, {4, -4}]}, 
          {GrayLevel[0], InsetBox[
            StyleBox["\<\"Rule 4a \[UpperLeftArrow]\[LeftArrow]\[Diamond]\"\>",
             StripOnInput->False,
             FontSize->10], NCache[{3, Rational[-5, 2]}, {3, -2.5}]]}, 
          {RGBColor[1., 0.8, 0.8], RectangleBox[{0, -4}, {1, -1}]}, 
          {GrayLevel[0], InsetBox[
            StyleBox["\<\"Rule 4b  \\n\[UpperLeftArrow]  \[Diamond]\"\>",
             StripOnInput->False,
             FontSize->10], NCache[{Rational[1, 2], -2.1}, {0.5, -2.1}]]}, 
          {RGBColor[1, 0, 1], RectangleBox[{-1, -4}, {0, -1}]}, 
          {GrayLevel[0], InsetBox[
            StyleBox["\<\"Rule 5 \[UpArrow]\[Diamond]\"\>",
             StripOnInput->False,
             FontSize->10], 
            NCache[{Rational[-1, 2], Rational[-5, 2]}, {-0.5, -2.5}]]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{-4, -4}, {-1, 0}]}, 
          {GrayLevel[0], InsetBox[
            StyleBox["\<\"Rule 6 \[RightArrow]\[Diamond]\"\>",
             StripOnInput->False,
             FontSize->10], NCache[{Rational[-5, 2], -2}, {-2.5, -2}]]}, 
          {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
           LineBox[{{-1.02, 0}, {-1.02, -3.98}}]}, 
          {RGBColor[0, 1, 0], Thickness[Large], Dashing[{}], 
           LineBox[{{-3.98, 0}, {-1, 0}}], 
           {GrayLevel[0], InsetBox[
             StyleBox["\<\"Rule 7 \[RightArrow]\"\>",
              StripOnInput->False,
              FontSize->10], {-3, 0.13}]}, 
           {RGBColor[1, 0, 0], Thickness[Large], LineBox[{{1, 0}, {3.98, 0}}], 
            {GrayLevel[0], InsetBox[
              StyleBox["\<\"Rule 8 \[LeftArrow]\"\>",
               StripOnInput->False,
               FontSize->10], {3, 0.13}]}, 
            {RGBColor[0, 1, 0], Thickness[Large], 
             LineBox[NCache[{{Rational[1, 2], -1.02}, {
                Rational[1, 2], -3.98}}, {{0.5, -1.02}, {0.5, -3.98}}]], 
             {GrayLevel[0], GeometricTransformationBox[InsetBox[
                StyleBox["\<\"Rule 9 \[LeftArrow]\"\>",
                 StripOnInput->False,
                 FontSize->10], {0.65, -3.4}], {{{0, 1}, {-1, 0}}, Center}]}, 
             {RGBColor[1, 0.5, 0], Thickness[Large], 
              LineBox[NCache[{{Rational[1, 2], 3.98}, {
                 Rational[1, 2], 0.02}}, {{0.5, 3.98}, {0.5, 0.02}}]], 
              {GrayLevel[0], GeometricTransformationBox[InsetBox[
                 StyleBox["\<\"Rule  10\[RightArrow]\"\>",
                  StripOnInput->False,
                  FontSize->10], {0.65, 2}], {{{0, 1}, {-1, 0}}, Center}]}, 
              {RGBColor[1, 1, 0], Thickness[Large], 
               LineBox[{{0, -1}, {3, -4}}], 
               {GrayLevel[0], GeometricTransformationBox[InsetBox[
                  StyleBox["\<\"Rule 11 \[LeftArrow]\"\>",
                   StripOnInput->False,
                   FontSize->10], {2.6, -3.4}], {{{0.7071067811865475, 
                  0.7071067811865475}, {-0.7071067811865475, 
                  0.7071067811865475}}, Center}]}, 
               {RGBColor[0, 0, 1], Thickness[Large], 
                LineBox[{{-3.98, 2.98}, {-1.02, 0.02}}], 
                {GrayLevel[0], GeometricTransformationBox[InsetBox[
                   StyleBox["\<\"Rule 12 \[RightArrow]\"\>",
                    StripOnInput->False,
                    FontSize->10], {-2.3, 1.5}], {{{0.7071067811865475, 
                   0.7071067811865475}, {-0.7071067811865475, 
                   0.7071067811865475}}, Center}]}, 
                {RGBColor[1, 1, 0], Thickness[Large], 
                 LineBox[{{-1, -1}, {2, -4}}], 
                 {GrayLevel[0], GeometricTransformationBox[InsetBox[
                    StyleBox["\<\"Rule 13 \[UpperLeftArrow]\"\>",
                    StripOnInput->False,
                    FontSize->10], {1.6, -3.4}], {{{0.7071067811865475, 
                    0.7071067811865475}, {-0.7071067811865475, 
                    0.7071067811865475}}, Center}]}, 
                 {RGBColor[0, 0, 1], Thickness[Large], 
                  LineBox[{{-3.98, 1.98}, {-1.02, -0.98}}], 
                  {GrayLevel[0], GeometricTransformationBox[InsetBox[
                    StyleBox["\<\"Rule 14 \[UpperRightArrow]\"\>",
                    StripOnInput->False,
                    FontSize->10], {-3.35, 1.55}], {{{0.7071067811865475, 
                    0.7071067811865475}, {-0.7071067811865475, 
                    0.7071067811865475}}, Center}]}, 
                  {GrayLevel[0], Thickness[Large], 
                   LineBox[{{0, 3.98}, {0, -3.98}}]}, 
                  {GrayLevel[0], Thickness[Large], 
                   LineBox[{{1, 3.98}, {1, -3.98}}]}, 
                  {GrayLevel[0], Thickness[Large], 
                   LineBox[{{2, 3.98}, {2, -3.98}}]}, 
                  {GrayLevel[0], Thickness[Large], 
                   LineBox[{{-3.98, 1}, {3.98, 1}}]}, 
                  {GrayLevel[0], Thickness[Large], 
                   LineBox[{{-3.98, 2}, {3.98, 2}}], 
                   {RGBColor[1., 0.3, 0.3], 
                    DiskBox[{-1, 0}, Scaled[Rational[1, 60]]]}, 
                   {GrayLevel[1], InsetBox["\<\"a\"\>", {-0.99, 0}]}, 
                   {RGBColor[1., 0.3, 0.3], 
                    DiskBox[NCache[{Rational[1, 2], 0}, {0.5, 0}], Scaled[
                    Rational[1, 60]]]}, 
                   {GrayLevel[1], InsetBox["\<\"b\"\>", {0.51, 0}]}, 
                   {RGBColor[1., 0.3, 0.3], 
                    DiskBox[NCache[{Rational[-1, 2], 0}, {-0.5, 0}], Scaled[
                    Rational[1, 60]]]}, 
                   {GrayLevel[1], InsetBox["\<\"c\"\>", {-0.49, 0}]}, 
                   {RGBColor[1., 0.3, 0.3], 
                    DiskBox[NCache[{Rational[1, 2], -1}, {0.5, -1}], Scaled[
                    Rational[1, 60]]]}, 
                   {GrayLevel[1], InsetBox["\<\"d\"\>", {0.51, -1}]}, 
                   {RGBColor[0, 1, 1], 
                    DiskBox[NCache[{Rational[-1, 2], -1}, {-0.5, -1}], Scaled[
                    Rational[1, 60]]]}, 
                   {GrayLevel[0], InsetBox["\<\"e\"\>", {-0.49, -1}]}, 
                   {RGBColor[1., 0.3, 0.3], 
                    DiskBox[
                    NCache[{Rational[-1, 2], Rational[-1, 2]}, {-0.5, -0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                   {GrayLevel[1], 
                    InsetBox["\<\"f\"\>", 
                    NCache[{-0.49, Rational[-1, 2]}, {-0.49, -0.5}]]}, 
                   {RGBColor[1., 0.3, 0.3], 
                    DiskBox[
                    NCache[{Rational[1, 2], Rational[-1, 2]}, {0.5, -0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                   {GrayLevel[1], 
                    InsetBox["\<\"g\"\>", 
                    NCache[{0.51, Rational[-1, 2]}, {0.51, -0.5}]]}, 
                   {RGBColor[0, 1, 1], 
                    DiskBox[
                    NCache[{Rational[-1, 2], Rational[1, 2]}, {-0.5, 0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                   {GrayLevel[0], 
                    InsetBox["\<\"h\"\>", 
                    NCache[{-0.49, Rational[1, 2]}, {-0.49, 0.5}]]}, 
                   {RGBColor[0, 1, 1], 
                    DiskBox[NCache[{-2, Rational[1, 2]}, {-2, 0.5}], Scaled[
                    Rational[1, 60]]]}, 
                   {GrayLevel[0], 
                    InsetBox["\<\"i\"\>", 
                    NCache[{-1.99, Rational[1, 2]}, {-1.99, 0.5}]]}, 
                   {RGBColor[0, 1, 1], 
                    DiskBox[NCache[{-2, Rational[3, 2]}, {-2, 1.5}], Scaled[
                    Rational[1, 60]]]}, 
                   {GrayLevel[0], 
                    InsetBox["\<\"i\"\>", 
                    NCache[{-1.99, Rational[3, 2]}, {-1.99, 
                    1.5}]]}}}}}}}}}}}}}}}}}},
  Axes->True,
  AxesLabel->{
    FormBox["n", TraditionalForm], 
    FormBox[
     RowBox[{"j", " ", "k", " ", "m"}], TraditionalForm]},
  ImageSize->Medium]], "Input",
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Legend:",
  FontWeight->"Bold"],
 "\n\[Bullet]  The rule number in a colored region indicates the rule to use \
for integrals in that region.\n\[Bullet]  The rule number next to a colored \
line indicates the rule to use for integrals on that line.\n\[Bullet]  A \
white region or line indicates there is no rule for integrals in that region \
or on that line.\n\[Bullet]  A solid black line indicates integrals on that \
line are handled by rules in another section.\n\[Bullet]  A dashed black line \
on the border of a region indicates integrals on that border are handled by \
the rule for that region.\n\[Bullet]  The arrow(s) following a rule number \
indicates the direction the rule drives integrands in the n\[Cross]m exponent \
plane.\n\[Bullet]  A \[Diamond] following a rule number indicates the rule \
transforms the integrand into a form handled by another section.\n\[Bullet]  \
A red (stop) disk indicates the terminal rule to use for the point at the \
center of the disk.\n\[Bullet]  A cyan disk indicates the non-terminal rule \
to use for the point at the center of the disk."
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvWx2qt8BmVeOAtpmKSBazPxXBoguPqZWAKJ3VvSW
gGje1yvrQXTvPN4WEL3DULwVRHNs1u0G0VVfRSeD6EsSC6eD6FV9WrNAtOHV
+HkgWv9Q6k4QHetWuh9EH7w48QCIdohIPgqin689BaaXtdWcBdEb3DovgOjl
RslXQHQI+4X7IPr7BK7nINq2WwJMfxN6/hpEt0g2vAfRR7xefgbRXudamA4C
6WcX4tlBtAzPSx4QbVPAJwSir/yqkwLROQtY5EG0j6SgFohmi8k0AdH7HrBZ
gOjD1z65gOiAl39dQfTDAstoEB2x+BuY7v4bmg6i5+RVgWkAeVypcw==
  "],
 FontSize->14],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["k", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["a", "2"]}], "=", 
      SuperscriptBox["b", "2"]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.5047258667134433`*^9, 3.5047259284235296`*^9, {
   3.50472971453883*^9, 3.504729719478837*^9}, {3.5047304814999037`*^9, 
   3.5047304917899184`*^9}, {3.5053445844837046`*^9, 
   3.5053445851537056`*^9}, {3.5100199355257735`*^9, 3.510019945338191*^9}, {
   3.510019976460245*^9, 3.510019976460245*^9}, {3.5101703833552046`*^9, 
   3.5101703833552046`*^9}, {3.5102544956897216`*^9, 
   3.5102544956897216`*^9}, {3.51041961730233*^9, 3.5104196259523425`*^9}, {
   3.51344227150583*^9, 3.513442273395832*^9}, 3.514736742420078*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["a",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.5021272389648304`*^9, 3.5021272415948343`*^9}, {3.504490508246251*^9, 
   3.5044905119162564`*^9}, {3.504490558286321*^9, 3.5044905783463497`*^9}, 
   3.5046318639667244`*^9, {3.5133764141713543`*^9, 3.5133764144313545`*^9}, {
   3.5133768494019637`*^9, 3.5133768529319687`*^9}, {3.5133769622021217`*^9, 
   3.5133769624321218`*^9}, 3.5136146877422624`*^9, 3.5136147334191427`*^9, {
   3.5136147801880245`*^9, 3.513614782606029*^9}, {3.513615527689342*^9, 
   3.5136155492953796`*^9}, 3.514736587808206*^9, 3.5151817724527583`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.555.3', CRC 337', A&S 4.3.134'/5'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4979222572169113`*^9, {3.515603311397254*^9, 
   3.5156033183572636`*^9}, {3.5156034225574093`*^9, 3.5156034228274097`*^9}}],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 
   3.5017335953768063`*^9}, {3.501733875319298*^9, 3.501733886769718*^9}, {
   3.5017340709904413`*^9, 3.501734096262486*^9}, 3.508786823163941*^9, {
   3.513882931481301*^9, 3.513882974681361*^9}, {3.513884456003435*^9, 
   3.5138844562234354`*^9}}],

Cell[TextData[{
 "Rule a1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.498240714363456*^9, 3.498240714363456*^9}, {
   3.504588147288866*^9, 3.504588147958867*^9}, 3.504590081521595*^9, 
   3.5136155872190466`*^9, 3.514736574158182*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
         ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4979216145737824`*^9, 3.4979216447910357`*^9}, 
   3.497922266920128*^9, {3.5053551460674343`*^9, 3.5053551625674577`*^9}, 
   3.5053551975975065`*^9, 3.505362823262396*^9, {3.513379457125614*^9, 
   3.513379457835615*^9}, 3.5151817786459694`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"d", "*", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, {3.4979216145737824`*^9, 
   3.4979216447910357`*^9}, 3.4979222491204967`*^9, {3.5053551460774345`*^9, 
   3.5053551625774574`*^9}, 3.5053551976075068`*^9, 3.5053628266724005`*^9, 
   3.513379480405647*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.555.4', CRC 338'/9', A&S 4.3.134'/5'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4979222572169113`*^9, {3.515603311397254*^9, 
   3.5156033183572636`*^9}, {3.5156033634873266`*^9, 3.5156033693373346`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"d", "*", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, {3.4979216145737824`*^9, 
   3.4979216447910357`*^9}, 3.4979222491204967`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.5002620149595757`*^9, {3.5119822460882673`*^9, 
   3.5119822484344015`*^9}, {3.5136162015793257`*^9, 3.513616203076928*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], "-", 
    FractionBox[
     RowBox[{"b", " ", "z"}], 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.513616405877284*^9, 3.513616440509345*^9}}],

Cell[TextData[{
 "Note: The rule for integrands of the same form when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 " could subsume this rule, but the resulting antiderivative will look less \
like the integrand involving sines instead of cosecants."
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}, {
   3.51198092332861*^9, 3.5119809284639034`*^9}, {3.513609260172001*^9, 
   3.513609261622803*^9}, {3.5147594629917507`*^9, 3.514759580281915*^9}, {
   3.5147596147519636`*^9, 3.5147597089720955`*^9}, {3.514759751312155*^9, 
   3.5147598248822575`*^9}, 3.514760177692752*^9}],

Cell[TextData[{
 "Rule a2: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4982408115335917`*^9, 
   3.4982408115335917`*^9}, {3.504396309416292*^9, 3.5043963109862947`*^9}, {
   3.504413193550866*^9, 3.5044131942308674`*^9}, {3.5044133130510335`*^9, 
   3.504413313411034*^9}, {3.508348841306343*^9, 3.508348842436345*^9}, {
   3.513095047017943*^9, 3.5130950482379446`*^9}, {3.513377117822339*^9, 
   3.51337711822234*^9}, {3.514597917336328*^9, 3.5145979175763283`*^9}, {
   3.5145980146964645`*^9, 3.5145980151564655`*^9}, {3.5147364697159986`*^9, 
   3.5147365218200903`*^9}, {3.51473657849499*^9, 3.5147365795713916`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.4987613369824286`*^9, 3.498761351202448*^9}, 3.4991763446448917`*^9, {
   3.499176403316595*^9, 3.4991764071698017`*^9}, 3.499195747838275*^9, {
   3.4991963654829597`*^9, 3.4991963700225677`*^9}, {3.4991968799254637`*^9, 
   3.499196884917472*^9}, {3.5002618027680025`*^9, 3.500261855808096*^9}, {
   3.5002619517014647`*^9, 3.5002619596574783`*^9}, {3.5104552095627546`*^9, 
   3.510455232022786*^9}, {3.5119822688505697`*^9, 3.511982278494121*^9}, {
   3.513616282668268*^9, 3.5136163233531394`*^9}, {3.515181784043579*^9, 
   3.51518180190561*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "a"}], " ", "-", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "/", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761354722453*^9, 3.4987613821124916`*^9}, 
   3.4987624269439545`*^9, 3.499176545495245*^9, {3.5002621484802103`*^9, 
   3.500262195607893*^9}, 3.500263694233178*^9, {3.510455241122799*^9, 
   3.510455275992848*^9}, {3.5119822283042507`*^9, 3.511982241072981*^9}, 
   3.51361651162987*^9, {3.5137914366421604`*^9, 3.513791444467608*^9}, {
   3.514736508528867*^9, 3.5147365123976736`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["b",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.5021272389648304`*^9, 3.5021272415948343`*^9}, {3.504490508246251*^9, 
   3.5044905119162564`*^9}, {3.504490558286321*^9, 3.5044905783463497`*^9}, 
   3.5046318639667244`*^9, {3.5133764141713543`*^9, 3.5133764144313545`*^9}, {
   3.5133768494019637`*^9, 3.5133768529319687`*^9}, {3.5133769622021217`*^9, 
   3.5133769624321218`*^9}, 3.5136146877422624`*^9, 3.5136147334191427`*^9, {
   3.5136147801880245`*^9, 3.513614782606029*^9}, 3.5136155309029474`*^9, 
   3.5151818315924625`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 
   3.5017335953768063`*^9}, {3.501733875319298*^9, 3.501733886769718*^9}, 
   3.5087868231739407`*^9, {3.513883533542144*^9, 3.5138835815022106`*^9}, {
   3.5138844630034447`*^9, 3.5138844634634457`*^9}}],

Cell[TextData[{
 "Rule b1: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4982407708135347`*^9, 3.4982407708135347`*^9}, {3.504588159968884*^9, 
   3.5045881608888855`*^9}, {3.5045900936916113`*^9, 3.504590093951612*^9}, {
   3.5136154813728604`*^9, 3.513615482761263*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], 
            "]"}]}]}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.497921614589382*^9, 
   3.497921644806636*^9}, 3.4979225240085793`*^9, {3.505355146147434*^9, 
   3.5053551625874577`*^9}, 3.5053551976475067`*^9, 3.505362928562543*^9, {
   3.513379464725625*^9, 3.5133794651656256`*^9}, 3.5151818333396654`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", "b", "*", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497922520046173*^9, {
   3.5053551461574345`*^9, 3.505355162597458*^9}, 3.505355197657507*^9, 
   3.50536293377255*^9, 3.513379506135683*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", "b", "*", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497922520046173*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Author: Martin on sci.math.symbolic on 10 March 2011", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, {
   3.4982419729252176`*^9, 3.498241999425255*^9}, {3.498242205975544*^9, 
   3.498242206945545*^9}, 3.504589884461319*^9, {3.513615195447156*^9, 
   3.513615217053193*^9}}],

Cell[TextData[{
 "Rule b2: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4982407708135347`*^9, 3.4982407708135347`*^9}, {3.504588159968884*^9, 
   3.5045881608888855`*^9}, {3.5045900936916113`*^9, 3.504590093951612*^9}, {
   3.5136154853040676`*^9, 3.5136154863804693`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox["a"]}], "d"]}]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["a"], " ", 
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.497921614589382*^9, 
   3.497921644806636*^9}, 3.4979225240085793`*^9, {3.505355146147434*^9, 
   3.5053551625874577`*^9}, 3.5053551976475067`*^9, 3.505362928562543*^9, {
   3.513379464725625*^9, 3.5133794651656256`*^9}, 3.513614837689726*^9, 
   3.5136149789791737`*^9, {3.5136153007629404`*^9, 3.513615304350947*^9}, {
   3.515181837863673*^9, 3.515181842746482*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}]}]}], "]"}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", "a", "]"}], "/", "d"}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "a", "]"}], "*", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497922520046173*^9, {
   3.5053551461574345`*^9, 3.505355162597458*^9}, 3.505355197657507*^9, 
   3.50536293377255*^9, 3.513379506135683*^9, {3.5136150226124506`*^9, 
   3.513615024266053*^9}, 3.5136150572413116`*^9, {3.5136153163005676`*^9, 
   3.513615320418975*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["c",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.5021272389648304`*^9, 3.5021272415948343`*^9}, {3.504490508246251*^9, 
   3.5044905119162564`*^9}, {3.504490558286321*^9, 3.5044905783463497`*^9}, 
   3.5046318639667244`*^9, {3.5133764141713543`*^9, 3.5133764144313545`*^9}, {
   3.5133768494019637`*^9, 3.5133768529319687`*^9}, {3.5133769622021217`*^9, 
   3.5133769624321218`*^9}, 3.5136146877422624`*^9, 3.5136147334191427`*^9, 
   3.513615501278496*^9, 3.5151818846325555`*^9, {3.516574172414384*^9, 
   3.5165741730543847`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["\<\
Note: Although not essential, this rule produces a simpler antiderivative \
than rule c3.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787029645586`*^9}, {3.513378780694667*^9, 
   3.5133787854946737`*^9}, {3.5134525763922577`*^9, 
   3.5134525768822584`*^9}, {3.513452687552413*^9, 3.5134526900824165`*^9}, {
   3.5151905781028967`*^9, 3.515190578942898*^9}, {3.5151906159629498`*^9, 
   3.5151906178029523`*^9}}],

Cell[TextData[{
 "Rule c1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, 3.4976400387242327`*^9, {
   3.504490585426359*^9, 3.5044905863663607`*^9}, {3.5046319134167933`*^9, 
   3.504631913666794*^9}, {3.5134526721023912`*^9, 3.5134526728323927`*^9}, 
   3.5136155063017044`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "2"], "]"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, 
   3.4976400727478924`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.4979232754930997`*^9, {3.499129231529621*^9, 3.4991292377396297`*^9}, {
   3.500665326343998*^9, 3.5006653286340013`*^9}, 3.513376911742051*^9, {
   3.515181974176713*^9, 3.5151819769691176`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, 
   3.4976400203630004`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.4979232490822535`*^9, {3.499129515580019*^9, 3.4991295254700327`*^9}, {
   3.5133788447747574`*^9, 3.5133788449447575`*^9}, 3.5133790045949807`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Note: Although not essential, this rule produces a simpler antiderivative \
than rule c3.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787029645586`*^9}, {3.513378780694667*^9, 
   3.5133787854946737`*^9}, {3.5134525742622547`*^9, 3.513452574812256*^9}, {
   3.5134526934224215`*^9, 3.513452694252423*^9}, {3.5151906306929703`*^9, 
   3.5151906412429852`*^9}}],

Cell[TextData[{
 "Rule c2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, {3.5044905820363545`*^9, 
   3.5044905832563562`*^9}, {3.5046319107667894`*^9, 3.50463191104679*^9}, {
   3.5134526749623957`*^9, 3.5134526756323967`*^9}, {3.5136155083453083`*^9, 
   3.5136155091721096`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}], 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "2"], "]"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, {3.500665322063992*^9, 
   3.500665324003995*^9}, {3.5133769023520374`*^9, 3.513376918972061*^9}, {
   3.5151819816179256`*^9, 3.5151819844727306`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, {3.51337883965475*^9, 
   3.5133788398447504`*^9}, 3.513379001864977*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule c3: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, {3.5007815669041595`*^9, 
   3.5007815669041595`*^9}, {3.5053561754188757`*^9, 3.505356175858876*^9}, 
   3.5133768939620256`*^9, 3.5136155132749166`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "2"], "-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", "b"}], 
      RowBox[{"4", "a"}]]}], "]"}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"], "-", 
      FractionBox[
       RowBox[{"\[Pi]", " ", "b"}], 
       RowBox[{"4", "a"}]]}], "]"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.4991295982501345`*^9, 3.4991296038701425`*^9}, {3.5007806832629223`*^9, 
   3.500780689482931*^9}, 3.500781551604138*^9, 3.500781748904414*^9, {
   3.5133769959521685`*^9, 3.5133769962021694`*^9}, 3.5151818902173653`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
      RowBox[{"Pi", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"4", "*", "a"}], ")"}]}]}]}], "]"}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "a"}], ")"}]}]}]}], "]"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.499129642150196*^9, 3.4991296506002073`*^9}, {3.5007807265629826`*^9, 
   3.500780730282988*^9}, {3.5007815769341736`*^9, 3.5007816235942388`*^9}, {
   3.5007817605844307`*^9, 3.5007817609944315`*^9}, {3.5007817924544754`*^9, 
   3.5007818323945312`*^9}, {3.5133788478747616`*^9, 3.5133788480347614`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "15"}], "-", "16"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.5044904183461256`*^9, 3.504490424426134*^9}, {3.5045901515116925`*^9, 
   3.5045901535016956`*^9}, 3.5053551625674577`*^9, {3.513379450805606*^9, 
   3.513379451645607*^9}, {3.513379562005761*^9, 3.5133795621857615`*^9}, 
   3.5135746594694138`*^9, 3.515182028418008*^9, {3.516578958437102*^9, 
   3.516578961367106*^9}, {3.5165800562086387`*^9, 3.516580058618642*^9}, {
   3.5165928140924273`*^9, 3.5165928197324357`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 6 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, 3.5018151793673925`*^9, 
   3.5087868232939415`*^9, {3.513387796477289*^9, 3.5133877972872906`*^9}, {
   3.5133975009950943`*^9, 3.5133975020150957`*^9}, {3.5136073197873917`*^9, 
   3.513607349770644*^9}, {3.5138839663827496`*^9, 3.5138839761627636`*^9}, {
   3.5138843353532667`*^9, 3.5138843355532665`*^9}, {3.5138844692934537`*^9, 
   3.513884469543454*^9}}],

Cell[TextData[{
 "Rule 15: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501812061374316*^9, 3.501812073838738*^9}, {
   3.5018891712996063`*^9, 3.5018891721496077`*^9}, 3.5018892149396677`*^9, {
   3.501889870350585*^9, 3.501889877930596*^9}, {3.5019616122915564`*^9, 
   3.5019616122915564`*^9}, {3.501963446484124*^9, 3.5019634484241266`*^9}, {
   3.5019854691076093`*^9, 3.5019854716876125`*^9}, {3.5019858450681353`*^9, 
   3.5019858450681353`*^9}, {3.50198626997873*^9, 3.501986271478732*^9}, 
   3.5021314533978634`*^9, {3.5023184824413586`*^9, 3.5023184926125765`*^9}, {
   3.502318577585926*^9, 3.50231858008193*^9}, {3.502329492721938*^9, 
   3.502329492721938*^9}, {3.50233161170686*^9, 3.5023316148268657`*^9}, {
   3.504489700745121*^9, 3.5044897024751234`*^9}, 3.505164492700603*^9, {
   3.5051648664611263`*^9, 3.5051648686311293`*^9}, {3.5051649653312645`*^9, 
   3.505164969751271*^9}, {3.505195341110135*^9, 3.505195341110135*^9}, 
   3.513387851927367*^9, {3.5133882448479176`*^9, 3.5133882461479187`*^9}, {
   3.5135745631548443`*^9, 3.513574578567672*^9}, {3.5135746371769743`*^9, 
   3.5135746387681775`*^9}, {3.513618068087191*^9, 3.5136180689971924`*^9}, {
   3.514145826625323*^9, 3.5141458272153234`*^9}, {3.5165800476986265`*^9, 
   3.516580048298628*^9}, {3.516592822062439*^9, 3.5165928241724415`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}], "-", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.513292062852798*^9, 3.513292242867111*^9}, {
   3.5132923801169157`*^9, 3.5132923861569242`*^9}, {3.5133942235351763`*^9, 
   3.5133943581717653`*^9}, {3.5136073575550575`*^9, 
   3.5136074705616565`*^9}, {3.513607547157791*^9, 3.513607554115403*^9}, {
   3.5151820605228643`*^9, 3.515182072956086*^9}, 3.515182125216178*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "*", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.501815185950604*^9, 3.501815193859818*^9}, 
   3.5018153663025208`*^9, {3.501963510624214*^9, 3.5019635224342303`*^9}, {
   3.5019853143173923`*^9, 3.501985331897417*^9}, {3.5023186901245236`*^9, 
   3.5023186995781403`*^9}, {3.502328108500306*^9, 3.5023281359095545`*^9}, {
   3.502329683447873*^9, 3.502329705787112*^9}, 3.502329766050018*^9, {
   3.5023316434061155`*^9, 3.5023316474465227`*^9}, {3.5023338521983953`*^9, 
   3.5023338551468005`*^9}, 3.502388666141232*^9, 3.5033390786331153`*^9, {
   3.5051874883769846`*^9, 3.505187491383157*^9}, 3.5051895386622543`*^9, {
   3.505355146767435*^9, 3.505355163097458*^9}, 3.505355198127507*^9, 
   3.5053635303733854`*^9, 3.5133879447774973`*^9, {3.513388013527593*^9, 
   3.513388014077594*^9}, 3.513388079607686*^9, 3.513388129147755*^9, 
   3.513394426691861*^9, 3.513440981923106*^9, {3.5136075185941405`*^9, 
   3.5136075367213726`*^9}, {3.5136076232703247`*^9, 
   3.5136076660611997`*^9}, {3.5136077097256765`*^9, 3.5136077199280944`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3a with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, {3.501808958164465*^9, 
   3.5018089598336678`*^9}, {3.5018887520990195`*^9, 3.5018887819590616`*^9}, 
   3.508786823253941*^9, {3.5133877456772184`*^9, 3.513387746207219*^9}, {
   3.513397486135073*^9, 3.5133974872850747`*^9}, {3.5135740384843225`*^9, 
   3.5135740427119303`*^9}, {3.5135741288500814`*^9, 3.513574143092907*^9}, {
   3.5138840298028383`*^9, 3.513884074972902*^9}}],

Cell[TextData[{
 "Rule 16: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501812061374316*^9, 3.501812073838738*^9}, {
   3.5018891712996063`*^9, 3.5018891721496077`*^9}, 3.5018892149396677`*^9, {
   3.501889870350585*^9, 3.501889877930596*^9}, {3.5019616122915564`*^9, 
   3.5019616122915564`*^9}, {3.501963446484124*^9, 3.5019634484241266`*^9}, {
   3.5019854691076093`*^9, 3.5019854716876125`*^9}, {3.5019858450681353`*^9, 
   3.5019858450681353`*^9}, {3.50198626997873*^9, 3.501986271478732*^9}, 
   3.5021314533978634`*^9, {3.5023184824413586`*^9, 3.5023184926125765`*^9}, {
   3.502318577585926*^9, 3.50231858008193*^9}, {3.502329492721938*^9, 
   3.502329492721938*^9}, {3.50233161170686*^9, 3.5023316148268657`*^9}, {
   3.504489700745121*^9, 3.5044897024751234`*^9}, 3.505164492700603*^9, {
   3.5051648664611263`*^9, 3.5051648686311293`*^9}, {3.5051649653312645`*^9, 
   3.505164969751271*^9}, {3.505195341110135*^9, 3.505195341110135*^9}, 
   3.513387851927367*^9, {3.5133882448479176`*^9, 3.5133882461479187`*^9}, {
   3.5135745631548443`*^9, 3.513574578567672*^9}, {3.5135746371769743`*^9, 
   3.5135746387681775`*^9}, {3.513607751206149*^9, 3.5136077519237504`*^9}, {
   3.5136180771072035`*^9, 3.5136180778272047`*^9}, {3.514145808465297*^9, 
   3.514145808465297*^9}, {3.5165800516786327`*^9, 3.516580052098633*^9}, {
   3.516592826862446*^9, 3.516592827822447*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["b", "2"], 
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "2"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["a", 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "n"}], "-", "4"}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018085031116657`*^9, 3.5018086153694625`*^9}, {3.5018087435704875`*^9, 
   3.5018087487340965`*^9}, {3.501808975870496*^9, 3.5018090631370487`*^9}, {
   3.5018887937290783`*^9, 3.5018888537491617`*^9}, {3.501888888759211*^9, 
   3.501889055159444*^9}, {3.504810640684278*^9, 3.5048106424142804`*^9}, {
   3.5053551465874352`*^9, 3.505355162927458*^9}, 3.505355197987507*^9, 
   3.505363506753352*^9, 3.5133881630578027`*^9, {3.513396391369046*^9, 
   3.5133965080260515`*^9}, {3.513574050012743*^9, 3.513574114264056*^9}, {
   3.5135741842613792`*^9, 3.513574255257104*^9}, {3.513574352055274*^9, 
   3.5135743573592834`*^9}, {3.5135745908292933`*^9, 3.513574592576496*^9}, {
   3.5151821046085415`*^9, 3.515182113282157*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"b", "^", "2"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", "*", "n"}], "-", "4"}], ")"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.5018091789952526`*^9, 3.5018091989008875`*^9}, {
   3.501819685414508*^9, 3.501819688050913*^9}, {3.5018891469595723`*^9, 
   3.501889181499621*^9}, {3.5018898212705164`*^9, 3.5018898634705753`*^9}, {
   3.5019616089115515`*^9, 3.501961609351552*^9}, {3.5019633974840555`*^9, 
   3.501963422914091*^9}, {3.5019854228875446`*^9, 3.501985423087545*^9}, 
   3.5019858423081317`*^9, {3.5019862622087193`*^9, 3.5019862650687237`*^9}, {
   3.502040617764885*^9, 3.502040622304493*^9}, {3.5021314494666567`*^9, 
   3.5021314500906577`*^9}, {3.5023068614118567`*^9, 3.50230686351786*^9}, {
   3.5023070664274163`*^9, 3.502307067332218*^9}, {3.5023184596809187`*^9, 
   3.502318475889347*^9}, {3.502327270872435*^9, 3.50232727330604*^9}, {
   3.50232738749824*^9, 3.5023273916634474`*^9}, {3.502327723741231*^9, 
   3.5023277250984335`*^9}, 3.5023295095075674`*^9, 3.5023315749999957`*^9, {
   3.5051645117606297`*^9, 3.5051645140606327`*^9}, {3.505195347520502*^9, 
   3.505195350617679*^9}, {3.505355146597435*^9, 3.5053551629474583`*^9}, 
   3.505355197997507*^9, 3.5053635089433556`*^9, 3.5133879042274404`*^9, {
   3.513387995507568*^9, 3.513387995967569*^9}, {3.5133880563076534`*^9, 
   3.5133880579376554`*^9}, 3.513388114727735*^9, 3.5133967152239943`*^9, 
   3.5134409559022603`*^9, {3.5135728220521855`*^9, 3.5135728378862133`*^9}, {
   3.5135744507722473`*^9, 3.5135745369623985`*^9}, {3.5136076733152122`*^9, 
   3.513607682800029*^9}, 3.514145783215262*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        SuperscriptBox["a", "2"]}], "=", 
       SuperscriptBox["b", "2"]}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.5047258667134433`*^9, 3.5047259284235296`*^9, {
   3.50472971453883*^9, 3.504729719478837*^9}, {3.5047304814999037`*^9, 
   3.5047304917899184`*^9}, {3.5053445844837046`*^9, 
   3.5053445851537056`*^9}, {3.5100199355257735`*^9, 3.510019945338191*^9}, {
   3.510019976460245*^9, 3.510019976460245*^9}, {3.5101703833552046`*^9, 
   3.5101703833552046`*^9}, {3.5102544956897216`*^9, 
   3.5102544956897216`*^9}, {3.5134422770858374`*^9, 3.5134422770858374`*^9}, 
   3.5147368175498095`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["d",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.50257751662256*^9, 3.502577527752576*^9}, 
   3.50258874160198*^9, 3.5036869166007347`*^9, {3.5044906345464277`*^9, 
   3.5044906357464294`*^9}, 3.5046318862967553`*^9, 3.508787655635106*^9, {
   3.5133764180513597`*^9, 3.51337641823136*^9}, {3.5133799315762787`*^9, 
   3.51337993266628*^9}, {3.5134524335020576`*^9, 3.513452461952098*^9}, 
   3.513923008321757*^9, {3.5151821848706827`*^9, 3.5151821870390863`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["\<\
Derivation: Piecewise constant extraction and trig substitution\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502084703554076*^9, 3.502084707532083*^9}}],

Cell[TextData[{
 "Basis: ",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     RowBox[{"Cos", "[", 
      FractionBox["z", "2"], "]"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]]]}], "=", "0"}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.50207476692389*^9, 3.5020747737723017`*^9}, {
   3.502217989821336*^9, 3.502218014219779*^9}, {3.5022184003524575`*^9, 
   3.502218400680058*^9}, 3.5022184373245225`*^9, {3.5022184771981926`*^9, 
   3.5022184806769986`*^9}}],

Cell[TextData[{
 "Basis: ",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.50207476692389*^9, 3.5020747737723017`*^9}, {
   3.502217989821336*^9, 3.502218014219779*^9}, {3.5022184003524575`*^9, 
   3.502218400680058*^9}, 3.5022184373245225`*^9, {3.5022184771981926`*^9, 
   3.5022184806769986`*^9}, 3.5022357451483955`*^9, {3.5022358586128855`*^9, 
   3.502235879761095*^9}}],

Cell["\<\
Note: Although not essential, this rule produces a simpler antiderivative \
than rule d3.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787029645586`*^9}, {3.513378780694667*^9, 
   3.5133787854946737`*^9}, {3.5134525742622547`*^9, 3.513452574812256*^9}, {
   3.5134526934224215`*^9, 3.513452694252423*^9}, {3.5134527406824875`*^9, 
   3.5134527409424877`*^9}, {3.515190691093055*^9, 3.5151906945130596`*^9}}],

Cell[TextData[{
 "Rule d1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, 3.4976400387242327`*^9, {
   3.5048161106415443`*^9, 3.5048161119315457`*^9}, {3.5087878317653527`*^9, 
   3.5087878321053534`*^9}, {3.513923011861762*^9, 3.5139230126817627`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", "a", " ", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "2"], "]"}]}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], 
  "                                         "}], "\[IndentingNewLine]", 
 RowBox[{"                                 ", 
  RowBox[{
   RowBox[{"\[LongRightArrow]", "  ", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", "b", "  ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "2"], "]"}]}], 
     RowBox[{"d", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"], "]"}]}], "]"}]}]}]}], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, {3.500665322063992*^9, 
   3.500665324003995*^9}, {3.5006735459555054`*^9, 3.500673548335509*^9}, 
   3.50067378444584*^9, {3.500673868565957*^9, 3.50067387043596*^9}, {
   3.500674037036193*^9, 3.5006740444662037`*^9}, 3.500674132086326*^9, {
   3.5006746906971083`*^9, 3.5006747035471263`*^9}, {3.50223496213461*^9, 
   3.502234994005433*^9}, {3.5022353886120033`*^9, 3.5022353946353474`*^9}, {
   3.5022354539687414`*^9, 3.502235457068918*^9}, {3.5022360483627386`*^9, 
   3.502236054278077*^9}, {3.5087872671745625`*^9, 3.508787324654643*^9}, {
   3.5087923750417137`*^9, 3.5087923797217197`*^9}, {3.513452512152168*^9, 
   3.5134525139521704`*^9}, 3.5134528686726665`*^9, {3.5134531084230022`*^9, 
   3.513453118323016*^9}, 3.513453350073341*^9, {3.5151822060711203`*^9, 
   3.5151822449775887`*^9}, {3.515971590682623*^9, 3.5159715925078263`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"Pi", "/", "2"}], "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"Sqrt", "[", "2", "]"}], "*", "b", "*", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, 
   3.4976400203630004`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.4979232490822535`*^9, {3.499129515580019*^9, 3.4991295254700327`*^9}, 
   3.500673974916106*^9, {3.500674141346339*^9, 3.5006741459563456`*^9}, {
   3.500674186596402*^9, 3.500674190066407*^9}, 3.500674717507146*^9, {
   3.5087873358146586`*^9, 3.5087873394246635`*^9}, {3.513379915306256*^9, 
   3.513379919566262*^9}, {3.5134524663221035`*^9, 3.5134524691021075`*^9}, {
   3.5134525349221992`*^9, 3.5134525367322025`*^9}, 3.5134533540633464`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and trig substitution\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502084703554076*^9, 3.502084707532083*^9}}],

Cell[TextData[{
 "Basis: ",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     RowBox[{"Sin", "[", 
      FractionBox["z", "2"], "]"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]]]}], "=", "0"}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.50207476692389*^9, 3.5020747737723017`*^9}, {
   3.502217989821336*^9, 3.502218014219779*^9}, {3.5022184003524575`*^9, 
   3.502218400680058*^9}, 3.5022184373245225`*^9}],

Cell[TextData[{
 "Basis: ",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.50207476692389*^9, 3.5020747737723017`*^9}, {
   3.502217989821336*^9, 3.502218014219779*^9}, {3.5022184003524575`*^9, 
   3.502218400680058*^9}, 3.5022184373245225`*^9, {3.5022184771981926`*^9, 
   3.5022184806769986`*^9}, 3.5022357451483955`*^9, {3.5022358586128855`*^9, 
   3.502235879761095*^9}, {3.502235987385251*^9, 3.5022359954417114`*^9}}],

Cell["\<\
Note: Although not essential, this rule produces a simpler antiderivative \
than rule d3.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787029645586`*^9}, {3.513378780694667*^9, 
   3.5133787854946737`*^9}, {3.5134525742622547`*^9, 3.513452574812256*^9}, {
   3.5134526934224215`*^9, 3.513452694252423*^9}, {3.5134527406824875`*^9, 
   3.5134527409424877`*^9}, {3.515190707453078*^9, 3.5151907095530806`*^9}}],

Cell[TextData[{
 "Rule d2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, {3.50481611467155*^9, 
   3.5048161154115505`*^9}, {3.508787835545358*^9, 3.5087878361553593`*^9}, {
   3.513923018221771*^9, 3.5139230184317713`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", "a", " ", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "2"], "]"}]}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], 
  "                                           "}], "\[IndentingNewLine]", 
 RowBox[{"                                ", 
  RowBox[{
   RowBox[{"\[LongRightArrow]", "  ", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", "a", "  ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "2"], "]"}]}], 
     RowBox[{"d", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"], "]"}]}], "]"}]}]}]}], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, {3.500665322063992*^9, 
   3.500665324003995*^9}, {3.5006735459555054`*^9, 3.500673548335509*^9}, 
   3.50067378444584*^9, {3.500673868565957*^9, 3.50067387043596*^9}, 
   3.5006745811069546`*^9, {3.500674748397189*^9, 3.500674751927194*^9}, {
   3.500674833377308*^9, 3.5006748343773093`*^9}, {3.5022361390849276`*^9, 
   3.5022361532127357`*^9}, {3.5022361994693813`*^9, 3.50223620136549*^9}, {
   3.5087873962847433`*^9, 3.5087874199547763`*^9}, {3.5087878092253213`*^9, 
   3.5087878107553234`*^9}, {3.5087924241417823`*^9, 3.508792427661787*^9}, 
   3.5134530837329683`*^9, {3.5134531219830217`*^9, 3.5134531617130775`*^9}, 
   3.5134532455431943`*^9, {3.5151822121707306`*^9, 3.515182214105134*^9}, {
   3.515182248991596*^9, 3.5151822574312105`*^9}, {3.515971602164243*^9, 
   3.5159716048006477`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"Pi", "/", "2"}], "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"Sqrt", "[", "2", "]"}], "*", "a", "*", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "*", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, 3.500673939616057*^9, {
   3.5006741802463937`*^9, 3.5006741823063965`*^9}, {3.5006746290670223`*^9, 
   3.5006746532170553`*^9}, 3.5006749138674207`*^9, 3.5087874386948023`*^9, {
   3.5133799229662666`*^9, 3.513379927656273*^9}, {3.5134524728721128`*^9, 
   3.5134524757221165`*^9}, {3.5134525407022076`*^9, 3.51345254260221*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and trig substitution\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502084703554076*^9, 3.502084707532083*^9}}],

Cell[TextData[{
 "Rule d3: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, 3.4976400387242327`*^9, {
   3.5048161106415443`*^9, 3.5048161119315457`*^9}, {3.5087911063499374`*^9, 
   3.5087911065699377`*^9}, {3.5134528078125815`*^9, 3.513452821562601*^9}, {
   3.5139230215217752`*^9, 3.513923022231776*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", "b", "  ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "2"], "-", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "b"}], 
          RowBox[{"4", "a"}]]}], "]"}]}], 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "2"], "-", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "b"}], 
        RowBox[{"4", "a"}]]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, {3.500665322063992*^9, 
   3.500665324003995*^9}, {3.5006735459555054`*^9, 3.500673548335509*^9}, 
   3.50067378444584*^9, {3.500673868565957*^9, 3.50067387043596*^9}, {
   3.500674037036193*^9, 3.5006740444662037`*^9}, 3.500674132086326*^9, {
   3.5006746906971083`*^9, 3.5006747035471263`*^9}, {3.50223496213461*^9, 
   3.502234994005433*^9}, {3.5022353886120033`*^9, 3.5022353946353474`*^9}, {
   3.5022354539687414`*^9, 3.502235457068918*^9}, {3.5022360483627386`*^9, 
   3.502236054278077*^9}, {3.505668118640586*^9, 3.505668154280636*^9}, {
   3.5087906028592324`*^9, 3.5087906396892843`*^9}, {3.5087922801815805`*^9, 
   3.5087923259816446`*^9}, {3.513379816476117*^9, 3.5133798171361184`*^9}, 
   3.513452901372713*^9, {3.5134532072631407`*^9, 3.5134532090031433`*^9}, {
   3.513453261053216*^9, 3.513453264613221*^9}, 3.5134533178432956`*^9, {
   3.513453376633378*^9, 3.5134533806633835`*^9}, {3.5151821938562984`*^9, 
   3.5151821954163013`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"Sqrt", "[", "2", "]"}], "*", "b", "*", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "a"}], ")"}]}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", "\n",
     "    ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
        RowBox[{"Pi", "*", 
         RowBox[{"b", "/", 
          RowBox[{"(", 
           RowBox[{"4", "*", "a"}], ")"}]}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, 
   3.4976400203630004`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.4979232490822535`*^9, {3.499129515580019*^9, 3.4991295254700327`*^9}, 
   3.500673974916106*^9, {3.500674141346339*^9, 3.5006741459563456`*^9}, {
   3.500674186596402*^9, 3.500674190066407*^9}, 3.500674717507146*^9, {
   3.505668118650586*^9, 3.505668154290636*^9}, 3.5087907981095057`*^9, {
   3.5133798379561477`*^9, 3.513379839206149*^9}, {3.5134534382634645`*^9, 
   3.513453515993573*^9}, 3.513453548593619*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["e",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["    ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.5021272389648304`*^9, 3.5021272415948343`*^9}, {3.504490508246251*^9, 
   3.5044905119162564`*^9}, {3.504490558286321*^9, 3.5044905783463497`*^9}, 
   3.5046318639667244`*^9, 3.5053551623674574`*^9, 3.508790989409774*^9, 
   3.5087910735798917`*^9, {3.5133799915663624`*^9, 3.5133799921463633`*^9}, {
   3.513724271905349*^9, 3.513724280922165*^9}, {3.5137243560206966`*^9, 
   3.513724361028305*^9}, 3.5139230602718296`*^9, {3.5151822801448507`*^9, 
   3.5151822816112533`*^9}, {3.5151832507161555`*^9, 
   3.5151832509813557`*^9}, {3.516574226004459*^9, 3.5165742317344666`*^9}, 
   3.516575167317792*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Author: Martin on sci.math.symbolic on 10 March 2011", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, {
   3.4982419729252176`*^9, 3.498241999425255*^9}, {3.498242205975544*^9, 
   3.498242206945545*^9}, 3.504589884461319*^9, {3.513615195447156*^9, 
   3.513615217053193*^9}}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["z", 
      FractionBox[
       RowBox[{"k", "+", "1"}], "2"]], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["z", "k"]}]}]]}]], "=", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["z", "k"]}]}]], 
     RowBox[{"a", " ", 
      SuperscriptBox["z", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]]}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      SuperscriptBox["z", 
       FractionBox[
        RowBox[{"k", "-", "1"}], "2"]]}], 
     RowBox[{"a", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["z", "k"]}]}]]}]]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}, {
   3.5006760576590223`*^9, 3.5006760794090524`*^9}, {3.500676130389124*^9, 
   3.500676132759127*^9}, 3.500676240689278*^9, 3.5006764023895044`*^9, {
   3.5006764330595474`*^9, 3.500676467739596*^9}, {3.5022467487167635`*^9, 
   3.502246767498838*^9}, {3.516574608534994*^9, 3.516574623285015*^9}, {
   3.516574724719163*^9, 3.5165747651392193`*^9}, {3.516574997667554*^9, 
   3.516575043887619*^9}, 3.516575103157702*^9}],

Cell[TextData[{
 "Rule e: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, {3.5006668696561584`*^9, 
   3.5006668721161623`*^9}, {3.500675666788475*^9, 3.5006756677784758`*^9}, 
   3.5006764070295115`*^9, {3.5048161931416597`*^9, 3.50481619370166*^9}, 
   3.5137247764614363`*^9, {3.5139231329419317`*^9, 3.513923133261932*^9}, 
   3.515183246535348*^9, {3.5165750921276865`*^9, 3.516575111407714*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "a"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       FractionBox[
        RowBox[{"k", "-", "1"}], "2"]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, 3.5006646650530725`*^9, {
   3.5006652709839206`*^9, 3.500665282473937*^9}, 3.5006668515961337`*^9, {
   3.5006668992662*^9, 3.5006669216762314`*^9}, {3.5006756467284465`*^9, 
   3.500675652058454*^9}, {3.500676422829533*^9, 3.500676426179538*^9}, {
   3.505668132210605*^9, 3.505668154310636*^9}, {3.5087906823493433`*^9, 
   3.508790694919361*^9}, {3.513379994056366*^9, 3.51337999677637*^9}, {
   3.5151822833740563`*^9, 3.5151822896296673`*^9}, {3.5165743691146593`*^9, 
   3.5165743732246647`*^9}, {3.5165744577447834`*^9, 
   3.5165744635047913`*^9}, {3.5165745062248507`*^9, 3.516574523114875*^9}, {
   3.5165745602349267`*^9, 3.516574587474965*^9}, {3.5165749628375053`*^9, 
   3.516574978037527*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, {3.5006670128563595`*^9, 
   3.500667030256384*^9}, {3.5006756721584826`*^9, 3.5006757072485313`*^9}, 
   3.5006761770891895`*^9, {3.500676504879648*^9, 3.500676511719658*^9}, {
   3.500676615389803*^9, 3.50067662058981*^9}, {3.505668132210605*^9, 
   3.505668154310636*^9}, {3.5087907393994236`*^9, 3.5087907621994553`*^9}, {
   3.513379997736371*^9, 3.5133800005263753`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]}]}]}], "]"}], ",", "x"}], "]"}]}], " ", 
    "-", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"b", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.499129642150196*^9, 3.4991296506002073`*^9}, {3.5007807265629826`*^9, 
   3.500780730282988*^9}, {3.5007815769341736`*^9, 3.5007816235942388`*^9}, {
   3.5007817605844307`*^9, 3.5007817609944315`*^9}, {3.5007817924544754`*^9, 
   3.5007818323945312`*^9}, {3.5133788478747616`*^9, 
   3.5133788480347614`*^9}, {3.5137260126356077`*^9, 3.51372601394601*^9}, {
   3.513726089606143*^9, 3.513726091727747*^9}, {3.5151819383434496`*^9, 
   3.515181949232269*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["f",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.503703965891255*^9, 3.503703966761256*^9}, {
   3.5037044347219114`*^9, 3.503704435171912*^9}, {3.503704484301981*^9, 
   3.5037044861219835`*^9}, {3.504490732226565*^9, 3.504490733706567*^9}, 
   3.504631888836759*^9, 3.5087878862754292`*^9, {3.5088681831149817`*^9, 
   3.508868183524005*^9}, {3.513376427481373*^9, 3.5133764277113733`*^9}, {
   3.513380020596403*^9, 3.5133800215464044`*^9}, {3.5133807808774676`*^9, 
   3.513380781317468*^9}, 3.51372393721636*^9, 3.51392314590195*^9, {
   3.5151823749462175`*^9, 3.5151823763034196`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    TemplateBox[{"z","0"},
     "EllipticF"], "=", "z"}], TraditionalForm]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.50207476692389*^9, 3.5020747737723017`*^9}, {
   3.502217989821336*^9, 3.502218014219779*^9}, {3.503608717861026*^9, 
   3.503608781311115*^9}}],

Cell[TextData[{
 "Note: This is a special case of the rule for ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "\[NotEqual]", 
   SuperscriptBox["b", "2"]}]]],
 "."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503704517332027*^9, 3.503704534352051*^9}}],

Cell[TextData[{
 "Rule f1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"a", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503609744422463*^9, 
   3.503609745742465*^9}, {3.503610478773491*^9, 3.503610480153493*^9}, {
   3.5037039974012995`*^9, 3.503704009951317*^9}, {3.5044906727664814`*^9, 
   3.5044907042265253`*^9}, {3.5046319342968225`*^9, 3.504631934646823*^9}, {
   3.5087908829296246`*^9, 3.508790883189625*^9}, {3.5133803707768936`*^9, 
   3.513380371546894*^9}, {3.513923156481964*^9, 3.513923157171965*^9}, {
   3.515190739073122*^9, 3.515190739863123*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox["2"], 
      RowBox[{"d", 
       SqrtBox["a"]}]]}]}], 
   RowBox[{"ArcSin", "[", 
    RowBox[{"Tan", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", "x"}]}], "2"], "-", 
      FractionBox["\[Pi]", "4"]}], "]"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501814357417549*^9, 3.5018144174776545`*^9}, {3.501821754446142*^9, 
   3.5018217794997864`*^9}, {3.501821876204356*^9, 3.501821879620762*^9}, {
   3.501821941724471*^9, 3.5018219589781017`*^9}, {3.5020737562757144`*^9, 
   3.5020738155090184`*^9}, 3.5036098300025826`*^9, 3.503609984502799*^9, {
   3.5036869781408205`*^9, 3.503686982000826*^9}, {3.505355145837434*^9, 
   3.505355162427457*^9}, 3.5053551974675064`*^9, 3.5053563655591416`*^9, 
   3.505356440189246*^9, {3.513380232196699*^9, 3.5133802328867006`*^9}, {
   3.515182379969426*^9, 3.515182381607429*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"Pi", "/", "2"}], "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", "a", "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcSin", "[", 
     RowBox[{"Tan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, 
   3.503608287880424*^9, {3.503608818201166*^9, 3.50360882090117*^9}, {
   3.5036097491924696`*^9, 3.5036097502324715`*^9}, 3.503609837132593*^9, 
   3.5036099906428075`*^9, {3.503610482913497*^9, 3.503610483843498*^9}, {
   3.5037042132616014`*^9, 3.50370421956161*^9}, {3.5133800275464125`*^9, 
   3.513380031706419*^9}, {3.513380213136673*^9, 3.5133802159666767`*^9}, {
   3.513380316726818*^9, 3.5133803196768217`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", "a", "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcSin", "[", 
     RowBox[{"Tan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
       RowBox[{"Pi", "/", "4"}]}], "]"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, 
   3.503608287880424*^9, {3.503608818201166*^9, 3.50360882090117*^9}, {
   3.5036097491924696`*^9, 3.5036097502324715`*^9}, 3.503609837132593*^9, 
   3.5036099906428075`*^9, {3.503610482913497*^9, 3.503610483843498*^9}, {
   3.5037042132616014`*^9, 3.50370421956161*^9}, {3.505355145847434*^9, 
   3.505355162437457*^9}, 3.5053551974775066`*^9, 3.505356366889144*^9, {
   3.505356448129257*^9, 3.505356449289259*^9}, {3.513380235906705*^9, 
   3.5133802364967055`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Author: Martin 10 March 2011", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502084703554076*^9, 3.502084707532083*^9}, {3.508867909890354*^9, 
   3.5088679102373743`*^9}, {3.5088682337248764`*^9, 
   3.5088682348079386`*^9}, {3.508869193368765*^9, 3.508869215454028*^9}}],

Cell["Derivation: ???", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502084703554076*^9, 3.502084707532083*^9}, {3.508867909890354*^9, 
   3.5088679102373743`*^9}}],

Cell[TextData[{
 "Rule f2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503609744422463*^9, 
   3.503609745742465*^9}, {3.503610478773491*^9, 3.503610480153493*^9}, {
   3.5037039974012995`*^9, 3.503704009951317*^9}, {3.5044906727664814`*^9, 
   3.5044907042265253`*^9}, {3.5046319342968225`*^9, 3.504631934646823*^9}, {
   3.508787887955432*^9, 3.508787888665433*^9}, {3.5088680763228736`*^9, 
   3.5088680818531895`*^9}, 3.508868202283078*^9, 3.5088698133122234`*^9, {
   3.50887119986753*^9, 3.5088712005935717`*^9}, {3.513380418796961*^9, 
   3.5133804194769616`*^9}, {3.5139231643519754`*^9, 3.51392316763198*^9}, {
   3.5151907438131285`*^9, 3.5151907441431293`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox["b"]}], 
       RowBox[{"a", " ", "d"}]]}]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["b"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501814357417549*^9, 3.5018144174776545`*^9}, {3.501821754446142*^9, 
   3.5018217794997864`*^9}, {3.501821876204356*^9, 3.501821879620762*^9}, {
   3.501821941724471*^9, 3.5018219589781017`*^9}, {3.5020737562757144`*^9, 
   3.5020738155090184`*^9}, 3.5036098300025826`*^9, 3.503609984502799*^9, {
   3.5036869781408205`*^9, 3.503686982000826*^9}, 3.508868061778042*^9, {
   3.5133806421172733`*^9, 3.5133806832473307`*^9}, {3.5151823841502333`*^9, 
   3.5151823858506365`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", "b", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "d"}], ")"}]}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "b", "]"}], "*", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, 
   3.503608287880424*^9, {3.503608818201166*^9, 3.50360882090117*^9}, {
   3.5036097491924696`*^9, 3.5036097502324715`*^9}, 3.503609837132593*^9, 
   3.5036099906428075`*^9, {3.503610482913497*^9, 3.503610483843498*^9}, {
   3.5037042132616014`*^9, 3.50370421956161*^9}, {3.508868151667183*^9, 
   3.5088681767086153`*^9}, {3.513380716687378*^9, 3.5133807485274224`*^9}, {
   3.513381176088021*^9, 3.513381180698027*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["g",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.503703965891255*^9, 3.503703966761256*^9}, {
   3.5037044347219114`*^9, 3.503704435171912*^9}, {3.503704484301981*^9, 
   3.5037044861219835`*^9}, {3.504490732226565*^9, 3.504490733706567*^9}, {
   3.5044908536267347`*^9, 3.5044908685867558`*^9}, 3.504631890266761*^9, {
   3.508788003945594*^9, 3.508788030395631*^9}, {3.5088681865761795`*^9, 
   3.508868186850195*^9}, {3.513376428801375*^9, 3.513376429011375*^9}, 
   3.5137239504295835`*^9, 3.513923179381996*^9, {3.5151826278226614`*^9, 
   3.515182628821063*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Author: Martin 10 March 2011", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502084703554076*^9, 3.502084707532083*^9}, {3.508867909890354*^9, 
   3.5088679102373743`*^9}, {3.5088682337248764`*^9, 
   3.5088682348079386`*^9}, {3.508869193368765*^9, 3.508869215454028*^9}}],

Cell["Derivation: ???", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502084703554076*^9, 3.502084707532083*^9}, {3.508867909890354*^9, 
   3.5088679102373743`*^9}}],

Cell[TextData[{
 "Rule g: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5020847974350405`*^9, 3.502084798417843*^9}, {
   3.504490952456873*^9, 3.5044909533268747`*^9}, {3.5046319563468533`*^9, 
   3.5046319565768538`*^9}, {3.508788006015597*^9, 3.508788006775598*^9}, {
   3.5088678834258404`*^9, 3.5088678866150227`*^9}, 3.513923182132*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox["b"]}], "d"]}]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["b"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501814357417549*^9, 3.5018144174776545`*^9}, {3.501821754446142*^9, 
   3.5018217794997864`*^9}, {3.501821876204356*^9, 3.501821879620762*^9}, {
   3.501821941724471*^9, 3.5018219589781017`*^9}, {3.5020737562757144`*^9, 
   3.5020738155090184`*^9}, {3.502084475219675*^9, 3.502084480055683*^9}, {
   3.5020845976798897`*^9, 3.5020846363835583`*^9}, {3.5020848407251167`*^9, 
   3.5020848649051595`*^9}, {3.5020849495421085`*^9, 3.502084966483738*^9}, 
   3.5044908795967712`*^9, {3.508787956835528*^9, 3.5087879583755302`*^9}, 
   3.508867865198798*^9, {3.5133809224676657`*^9, 3.513380938697688*^9}, {
   3.515182630490266*^9, 3.5151826317694683`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", "b", "]"}], "/", "d"}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "b", "]"}], "*", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, {
   3.5020847252381144`*^9, 3.5020847294345217`*^9}, {3.502084771304995*^9, 
   3.5020847933010335`*^9}, 3.502084920869258*^9, {3.502085568025194*^9, 
   3.502085570583599*^9}, 3.50886796279538*^9, {3.5088680017736096`*^9, 
   3.508868004166746*^9}, {3.5133809677677293`*^9, 3.5133809858877544`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["h",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["    ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.50257751662256*^9, 3.502577527752576*^9}, 
   3.50258874160198*^9, 3.5036869166007347`*^9, {3.5044906345464277`*^9, 
   3.5044906357464294`*^9}, 3.5046318862967553`*^9, {3.505355162397457*^9, 
   3.505355162397457*^9}, 3.5087908569695883`*^9, {3.5133812329781003`*^9, 
   3.5133812334581013`*^9}, {3.513923270672124*^9, 3.5139232773321333`*^9}, {
   3.515182670098736*^9, 3.5151826711751375`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502157546777938*^9, 3.502157550157943*^9}}],

Cell[TextData[{
 "Basis:  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SqrtBox["z"], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]], "=", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}]], 
     RowBox[{"b", " ", 
      SqrtBox["z"]}]], "-", 
    FractionBox["a", 
     RowBox[{"b", " ", 
      SqrtBox["z"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}]]}]}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.502157565987965*^9, 3.5021575687279687`*^9}}],

Cell[TextData[{
 "Rule h: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.502074080168284*^9, 3.502074080636285*^9}, {
   3.5020742717990203`*^9, 3.502074305073879*^9}, {3.5021576750081177`*^9, 
   3.502157675948119*^9}, {3.504490660426464*^9, 3.504490660796465*^9}, 
   3.5046319235868073`*^9, 3.5087908632395973`*^9, 3.515182768160508*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501814357417549*^9, 3.5018144174776545`*^9}, {3.501821754446142*^9, 
   3.5018217794997864`*^9}, {3.501821876204356*^9, 3.501821879620762*^9}, {
   3.501821941724471*^9, 3.5018219589781017`*^9}, {3.5020737562757144`*^9, 
   3.5020738155090184`*^9}, {3.502074068873864*^9, 3.502074103287524*^9}, {
   3.502074222097333*^9, 3.502074222580934*^9}, {3.502074331141525*^9, 
   3.5020743532623634`*^9}, {3.502157531417917*^9, 3.5021575412379303`*^9}, {
   3.5021576018980155`*^9, 3.502157644398075*^9}, 3.5021579134284515`*^9, 
   3.5036869522307844`*^9, {3.505355162397457*^9, 3.5053551624074574`*^9}, {
   3.513381233988102*^9, 3.513381235948105*^9}, {3.515182672953541*^9, 
   3.515182680425954*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, {
   3.5020741121795397`*^9, 3.5020741279043674`*^9}, {3.502074235014156*^9, 
   3.5020742444521723`*^9}, {3.5020743100034876`*^9, 3.502074313622694*^9}, {
   3.502074430045698*^9, 3.5020744584377484`*^9}, 3.5020748031939535`*^9, {
   3.5021576806281257`*^9, 3.502157699638152*^9}, {3.5021577549182296`*^9, 
   3.5021577603782372`*^9}, {3.5053551624074574`*^9, 3.505355162417457*^9}, {
   3.5133812370681067`*^9, 3.51338123986811*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["i",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "/", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5023422929020205`*^9, 3.502342295008024*^9}, {
   3.5025708612849264`*^9, 3.502570865774933*^9}, 3.502576943561758*^9, {
   3.5044916442778416`*^9, 3.50449165719786*^9}, {3.5046313093145866`*^9, 
   3.5046313116389904`*^9}, {3.5051789810963964`*^9, 
   3.5051789830985107`*^9}, {3.5053551627274575`*^9, 
   3.5053551627374573`*^9}, {3.513381576538582*^9, 3.513381576728582*^9}, {
   3.5133876287170544`*^9, 3.513387633377061*^9}, {3.5136330521050463`*^9, 
   3.5136330546850495`*^9}, 3.5136330851750927`*^9, {3.513633121005142*^9, 
   3.5136331311751566`*^9}, {3.513633177005221*^9, 3.5136331775452213`*^9}, {
   3.5136360541292486`*^9, 3.5136360562592516`*^9}, {3.513636099319312*^9, 
   3.513636124949348*^9}, {3.513638027122011*^9, 3.5136380282720127`*^9}, {
   3.5151838578952227`*^9, 3.5151838590496244`*^9}, 3.515257512261784*^9, {
   3.5152575489218483`*^9, 3.5152575512618523`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "2"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, 3.501814332956706*^9, 3.5087868232439413`*^9, {
   3.5133877168971777`*^9, 3.513387717377179*^9}, {3.5133931839869146`*^9, 
   3.513393184966916*^9}, {3.5136333675454874`*^9, 3.513633467905628*^9}, 
   3.5136336860859337`*^9, {3.5136340124563904`*^9, 3.513634023016405*^9}, {
   3.5136377232615857`*^9, 3.5136377306615963`*^9}, {3.5136389503633037`*^9, 
   3.5136389638233223`*^9}, {3.5138847239438105`*^9, 3.513884735503826*^9}}],

Cell[TextData[{
 "Rule i: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "2"}]}], "=", 
      "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.5019852252072678`*^9, 3.5019852285472727`*^9}, {
   3.50205482983051*^9, 3.502054831110512*^9}, {3.504489651525052*^9, 
   3.5044896818350945`*^9}, {3.505189371841713*^9, 3.505189371841713*^9}, {
   3.51338783997735*^9, 3.513387844567357*^9}, 3.513388233827902*^9, {
   3.5136349009276342`*^9, 3.513634920007661*^9}, {3.513635437808386*^9, 
   3.5136354381283865`*^9}, {3.513637750321624*^9, 3.5136377579916344`*^9}, {
   3.513638998603371*^9, 3.5136389990233717`*^9}, 3.5152575209509993`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"]}], 
        RowBox[{"3", "b", " ", "d", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          "2"]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"6", " ", "a", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.513392577705661*^9, 3.513392609975706*^9}, {
   3.513392694215824*^9, 3.513392704875839*^9}, {3.513392737255884*^9, 
   3.51339274112589*^9}, {3.5133931028868012`*^9, 3.513393163546886*^9}, 
   3.513633573655776*^9, 3.5136337054059606`*^9, {3.513633908686245*^9, 
   3.5136339188862596`*^9}, {3.5136339671663275`*^9, 
   3.5136339731863356`*^9}, {3.513634122726545*^9, 3.5136341325965586`*^9}, {
   3.513634166716606*^9, 3.5136342310166965`*^9}, 3.5136344582470145`*^9, 
   3.513634873637596*^9, {3.5136376068214226`*^9, 3.5136376588314953`*^9}, {
   3.513637689391538*^9, 3.513637715651575*^9}, {3.5136377956516867`*^9, 
   3.513637832821739*^9}, {3.5136393468638587`*^9, 3.5136393472538595`*^9}, {
   3.515183861420829*^9, 3.515183864899635*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{"3", "*", "b", "*", "d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "2"}]}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"6", "*", "a", "*", "b"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"j", "*", "k"}]}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "k", "-", "2"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018783882040033`*^9, 
   3.5018783932040105`*^9}, 3.501910304356453*^9, {3.5019850179769773`*^9, 
   3.5019850211269817`*^9}, {3.50198507709706*^9, 3.5019850837970695`*^9}, {
   3.501985197727229*^9, 3.5019851992872314`*^9}, {3.5020548244905024`*^9, 
   3.502054825820504*^9}, {3.5023202436376524`*^9, 3.502320247444059*^9}, {
   3.5023379615108128`*^9, 3.5023379654264197`*^9}, 3.5033390642030897`*^9, {
   3.505187411879609*^9, 3.505187412225629*^9}, 3.5051875191207433`*^9, {
   3.5053551465274353`*^9, 3.505355162877458*^9}, 3.505355197947507*^9, 
   3.505363500433344*^9, 3.5133878886374187`*^9, {3.5133879881275578`*^9, 
   3.5133879885875587`*^9}, 3.513388040607631*^9, 3.513388109027727*^9, 
   3.5133930839067745`*^9, {3.5133933124866967`*^9, 3.513393352116752*^9}, {
   3.513394105465011*^9, 3.5133941178350286`*^9}, 3.51344093298582*^9, 
   3.513635121997944*^9, {3.51363538327831*^9, 3.5136354191183596`*^9}, {
   3.513635606498622*^9, 3.5136356194786406`*^9}, 3.5136377627216406`*^9, 
   3.513638767423047*^9, {3.51363879797309*^9, 3.5136388009330945`*^9}, {
   3.513638870213191*^9, 3.5136388859832134`*^9}, {3.5136393391138477`*^9, 
   3.513639339913849*^9}, 3.516820808456675*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "n", "+", "k"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, 3.501814332956706*^9, 3.5087868232439413`*^9, {
   3.5133877168971777`*^9, 3.513387717377179*^9}, {3.5133931839869146`*^9, 
   3.513393184966916*^9}, {3.5136333675454874`*^9, 3.513633467905628*^9}, 
   3.5136336860859337`*^9, {3.5136340124563904`*^9, 3.513634023016405*^9}, {
   3.5136389669133267`*^9, 3.5136389676633277`*^9}, {3.5138847611838627`*^9, 
   3.513884770873876*^9}}],

Cell[TextData[{
 "Note: Unfortunately this interesting looking rule seems to be of no use \
except for the above special case when ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, 3.501814332956706*^9, 3.5087868232439413`*^9, {
   3.5133877168971777`*^9, 3.513387717377179*^9}, {3.5133931839869146`*^9, 
   3.513393184966916*^9}, {3.5136333675454874`*^9, 3.513633467905628*^9}, 
   3.5136336860859337`*^9, {3.5136340124563904`*^9, 3.513634023016405*^9}, {
   3.5136389669133267`*^9, 3.5136389676633277`*^9}, {3.5136393769239006`*^9, 
   3.5136394343039813`*^9}, {3.5136394856940527`*^9, 3.513639486384054*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "n", "+", "k"}]}], "=", 
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
       RowBox[{"n", "<", 
        RowBox[{"-", "1"}]}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.5019852252072678`*^9, 3.5019852285472727`*^9}, {
   3.50205482983051*^9, 3.502054831110512*^9}, {3.504489651525052*^9, 
   3.5044896818350945`*^9}, {3.505189371841713*^9, 3.505189371841713*^9}, {
   3.51338783997735*^9, 3.513387844567357*^9}, 3.513388233827902*^9, {
   3.5136349009276342`*^9, 3.513634920007661*^9}, {3.513635437808386*^9, 
   3.5136354381283865`*^9}, {3.513637772261654*^9, 3.513637778371663*^9}, {
   3.513639000723374*^9, 3.513639001413375*^9}, {3.515190877473316*^9, 
   3.5151908782733173`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"2", "a", " ", "b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.513392577705661*^9, 3.513392609975706*^9}, {
   3.513392694215824*^9, 3.513392704875839*^9}, {3.513392737255884*^9, 
   3.51339274112589*^9}, {3.5133931028868012`*^9, 3.513393163546886*^9}, 
   3.513633573655776*^9, 3.5136337054059606`*^9, {3.513633908686245*^9, 
   3.5136339188862596`*^9}, {3.5136339671663275`*^9, 
   3.5136339731863356`*^9}, {3.513634122726545*^9, 3.5136341325965586`*^9}, {
   3.513634166716606*^9, 3.5136342310166965`*^9}, 3.5136344582470145`*^9, 
   3.513634873637596*^9, {3.5151838710460453`*^9, 3.515183877254856*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
       "m_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
       "^", "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
      "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
        "n"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "d", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
     " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "a", "*", "b", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", 
             RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"OneQ", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], ",", 
       RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "n", "+", "k"}], 
      "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018783882040033`*^9, 
   3.5018783932040105`*^9}, 3.501910304356453*^9, {3.5019850179769773`*^9, 
   3.5019850211269817`*^9}, {3.50198507709706*^9, 3.5019850837970695`*^9}, {
   3.501985197727229*^9, 3.5019851992872314`*^9}, {3.5020548244905024`*^9, 
   3.502054825820504*^9}, {3.5023202436376524`*^9, 3.502320247444059*^9}, {
   3.5023379615108128`*^9, 3.5023379654264197`*^9}, 3.5033390642030897`*^9, {
   3.505187411879609*^9, 3.505187412225629*^9}, 3.5051875191207433`*^9, {
   3.5053551465274353`*^9, 3.505355162877458*^9}, 3.505355197947507*^9, 
   3.505363500433344*^9, 3.5133878886374187`*^9, {3.5133879881275578`*^9, 
   3.5133879885875587`*^9}, 3.513388040607631*^9, 3.513388109027727*^9, 
   3.5133930839067745`*^9, {3.5133933124866967`*^9, 3.513393352116752*^9}, {
   3.513394105465011*^9, 3.5133941178350286`*^9}, 3.51344093298582*^9, 
   3.513635121997944*^9, {3.51363538327831*^9, 3.5136354191183596`*^9}, {
   3.513635606498622*^9, 3.5136356194786406`*^9}, {3.5136375723113747`*^9, 
   3.5136375756813793`*^9}, 3.516820808466675*^9, 3.5168236464428797`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, 3.513605913762121*^9, 
   3.513795251900381*^9, {3.513805960417873*^9, 3.5138059633160386`*^9}, {
   3.513833340295154*^9, 3.513833340514167*^9}, 3.5151828059125743`*^9, {
   3.515182972630067*^9, 3.5151829756096725`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Note: Although the integrand equals ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"b", "+", 
    RowBox[{"a", " ", 
     RowBox[{"sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]],
 " which is easily integrated, this antiderivative is more similar in form to \
the integrand."
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.502157546777938*^9, 3.502157550157943*^9}, {3.5136060991060467`*^9, 
   3.513606284293972*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.502074080168284*^9, 3.502074080636285*^9}, {
   3.5020742717990203`*^9, 3.502074305073879*^9}, {3.5021576750081177`*^9, 
   3.502157675948119*^9}, {3.504490660426464*^9, 3.504490660796465*^9}, 
   3.5046319235868073`*^9, 3.5087908632395973`*^9, {3.513605968845818*^9, 
   3.513605969033018*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cot", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
         ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.510792914041258*^9, 
   3.5107929153912597`*^9}, {3.5136049227327805`*^9, 
   3.5136049455244207`*^9}, {3.513605223381708*^9, 3.513605223678109*^9}, {
   3.513605255002964*^9, 3.5136052797758074`*^9}, 3.5136053169818726`*^9, {
   3.513605675783703*^9, 3.5136056794341097`*^9}, {3.515182831340619*^9, 
   3.515182833633823*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"d", "*", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.510792916381261*^9, 
   3.5107929192812653`*^9}, {3.5107989134944706`*^9, 
   3.5107989488945203`*^9}, {3.5107990003145924`*^9, 3.510799003754597*^9}, 
   3.5107991079947433`*^9, {3.5107993333670607`*^9, 3.5107993423770733`*^9}, 
   3.5107997531676483`*^9, {3.5108036254530697`*^9, 3.5108036808831472`*^9}, {
   3.5108037152731953`*^9, 3.5108037341632223`*^9}, 3.5118378461156254`*^9, {
   3.5135750652261267`*^9, 3.5135750667549295`*^9}, {3.5136059383009644`*^9, 
   3.51360594153017*^9}, {3.5136060003890734`*^9, 3.5136060141638975`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   RowBox[{"-", "1"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.5011791668716116`*^9, 
   3.5011791710116177`*^9}, {3.501353551475207*^9, 3.5013535531444097`*^9}, 
   3.5016214475306363`*^9, 3.501621732503936*^9, 3.50163764784552*^9, {
   3.513654551447029*^9, 3.51365455217703*^9}, {3.5136566220499277`*^9, 
   3.5136566439099584`*^9}, {3.5137956398775716`*^9, 3.513795653334341*^9}, 
   3.5137968737681465`*^9, {3.5138327605819964`*^9, 3.5138327777039757`*^9}, {
   3.513833394653263*^9, 3.5138334034977694`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5136558067487864`*^9, 3.5136558085287886`*^9}, {
   3.5136565322798023`*^9, 3.5136565328398027`*^9}, {3.513795385267009*^9, 
   3.513795386480078*^9}, {3.5137954508697615`*^9, 3.5137954512667837`*^9}, 
   3.513796189653017*^9, {3.5137974643369246`*^9, 3.513797465339982*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], 
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", "b", " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{"d", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], 
            "]"}]}]}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.513656669489994*^9, 
   3.5136567604401217`*^9}, {3.5136568072701874`*^9, 3.513656829250218*^9}, {
   3.513795197733282*^9, 3.513795317608139*^9}, {3.5137954161337748`*^9, 
   3.5137954227951555`*^9}, {3.513795600493319*^9, 3.5137956051905875`*^9}, {
   3.5137968821626263`*^9, 3.5137969630662537`*^9}, 3.5151828455054436`*^9, {
   3.5151830121605363`*^9, 3.5151830144849405`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", "b", "*", 
    RowBox[{
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, {3.513656934580365*^9, 3.513656989690442*^9}, {
   3.513657056540536*^9, 3.5136570847905755`*^9}, {3.5136572776408453`*^9, 
   3.513657278700847*^9}, 3.513795095427431*^9, {3.5137954552880135`*^9, 
   3.513795485066717*^9}, {3.5137955829433155`*^9, 3.513795587814594*^9}, {
   3.5137956180853252`*^9, 3.513795623374628*^9}, 3.5137961784413757`*^9, {
   3.5137970079398203`*^9, 3.5137970171063447`*^9}, 3.51379706056083*^9, 
   3.5137974607917223`*^9, {3.5151830610822225`*^9, 3.5151830658090305`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Author: Martin on sci.math.symbolic on 10 March 2011", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, {
   3.4982419729252176`*^9, 3.498241999425255*^9}, {3.498242205975544*^9, 
   3.498242206945545*^9}, 3.504589884461319*^9, {3.513615195447156*^9, 
   3.513615217053193*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, {3.5006668696561584`*^9, 
   3.5006668721161623`*^9}, {3.500675666788475*^9, 3.5006756677784758`*^9}, 
   3.5006764070295115`*^9, {3.5048161931416597`*^9, 3.50481619370166*^9}, 
   3.5137247783958397`*^9, {3.513923136711937*^9, 3.5139231374419374`*^9}, {
   3.5151907728731694`*^9, 3.51519077341317*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"2", "a"}]], 
       RowBox[{"b", " ", "d"}]]}]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["a"], " ", 
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, 3.5006646650530725`*^9, {
   3.5006652709839206`*^9, 3.500665282473937*^9}, 3.5006668515961337`*^9, {
   3.5006668992662*^9, 3.5006669216762314`*^9}, {3.5006756467284465`*^9, 
   3.500675652058454*^9}, {3.500676422829533*^9, 3.500676426179538*^9}, {
   3.505668132210605*^9, 3.505668154310636*^9}, {3.5087906823493433`*^9, 
   3.508790694919361*^9}, {3.513379994056366*^9, 3.51337999677637*^9}, {
   3.513724328907849*^9, 3.513724331965454*^9}, {3.513724406424385*^9, 
   3.5137244203552094`*^9}, 3.513724465704489*^9, {3.5137246153911533`*^9, 
   3.513724650241615*^9}, 3.513724691004486*^9, {3.5151823055260954`*^9, 
   3.5151823322801423`*^9}, {3.5151832144304914`*^9, 3.515183217238497*^9}, {
   3.516414325622828*^9, 3.5164143288928328`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "*", "a"}], "]"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "d"}], ")"}]}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "a", "]"}], "*", 
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"c", " ", "+", " ", 
         RowBox[{"d", "*", "x"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", " ", "+", " ", 
           RowBox[{"b", "*", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", " ", "+", " ", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, {3.5006670128563595`*^9, 
   3.500667030256384*^9}, {3.5006756721584826`*^9, 3.5006757072485313`*^9}, 
   3.5006761770891895`*^9, {3.500676504879648*^9, 3.500676511719658*^9}, {
   3.500676615389803*^9, 3.50067662058981*^9}, {3.505668132210605*^9, 
   3.505668154310636*^9}, {3.5087907393994236`*^9, 3.5087907621994553`*^9}, {
   3.513379997736371*^9, 3.5133800005263753`*^9}, {3.513724786383054*^9, 
   3.5137247879274564`*^9}, 3.513724826861925*^9, {3.5164143414928503`*^9, 
   3.516414344232854*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, 3.513605913762121*^9, 
   3.513795251900381*^9, {3.513805960417873*^9, 3.5138059633160386`*^9}, 
   3.5138332641417985`*^9, 3.5151828105769825`*^9, {3.515183177021626*^9, 
   3.5151831868964434`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 1a with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   RowBox[{"-", "2"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, 3.501878569854258*^9, 
   3.508786823253941*^9, {3.513387735967205*^9, 3.5133877365072055`*^9}, {
   3.5133974837550697`*^9, 3.5133974848950715`*^9}, {3.513804671525152*^9, 
   3.513804735354803*^9}, {3.515268477737583*^9, 3.5152684784551845`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5136558067487864`*^9, 3.5136558085287886`*^9}, {
   3.5136565322798023`*^9, 3.5136565328398027`*^9}, {3.513795385267009*^9, 
   3.513795386480078*^9}, {3.5137954508697615`*^9, 3.5137954512667837`*^9}, 
   3.513796189653017*^9, {3.5138063499271517`*^9, 3.5138063506981955`*^9}, {
   3.513806444070536*^9, 3.5138064560022182`*^9}, {3.5138066614379687`*^9, 
   3.5138066614379687`*^9}, {3.5138332837659206`*^9, 3.513833293061453*^9}, {
   3.5150191204886813`*^9, 3.515019133430422*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", " ", "\[IndentingNewLine]", " ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5094830441507564`*^9, 3.5094831917952013`*^9}, {3.5094833027715483`*^9, 
   3.509483305747719*^9}, {3.509483389621516*^9, 3.5094834110637426`*^9}, {
   3.5095009204610405`*^9, 3.509500920663841*^9}, {3.509501209981949*^9, 
   3.509501254878828*^9}, {3.513803148620047*^9, 3.513803234815977*^9}, {
   3.513803272437129*^9, 3.513803274189229*^9}, {3.5138033629023037`*^9, 
   3.5138034119621096`*^9}, {3.5138034464640827`*^9, 3.5138034837682166`*^9}, 
   3.5138332738463535`*^9, {3.515183340681514*^9, 3.51518337292677*^9}, {
   3.5152675605135717`*^9, 3.515267562510375*^9}, 3.5152678316468487`*^9, 
   3.515267910114986*^9, {3.5152679756663013`*^9, 3.515267976118702*^9}, 
   3.5152680298607965`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "2"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.509483206773058*^9, 3.509483232269516*^9}, {3.509483529175498*^9, 
   3.509483565841595*^9}, {3.5094836038257675`*^9, 3.509483605101841*^9}, {
   3.5095009240490465`*^9, 3.5095009272782526`*^9}, {3.5095012643168445`*^9, 
   3.5095013143617325`*^9}, 3.5099029224730244`*^9, {3.5099334141350336`*^9, 
   3.5099334155450354`*^9}, 3.5104336477619963`*^9, 3.510551779322821*^9, 
   3.511813228736384*^9, {3.5138043779653616`*^9, 3.5138043823316116`*^9}, {
   3.5138044682855277`*^9, 3.513804528375965*^9}, {3.51380585931609*^9, 
   3.513805862448269*^9}, 3.5138063367613983`*^9, {3.513806425834493*^9, 
   3.513806436602109*^9}, {3.513806646689125*^9, 3.5138066682863607`*^9}, {
   3.5138332097796893`*^9, 3.5138332177931476`*^9}, {3.5150190880908284`*^9, 
   3.515019099917505*^9}, {3.5151833845799904`*^9, 3.515183412379239*^9}, {
   3.515267603788048*^9, 3.51526760522325*^9}, {3.515267654472536*^9, 
   3.5152676572337413`*^9}, {3.5152680723864713`*^9, 3.515268091668105*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 2 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   RowBox[{"-", "2"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, 3.501878569854258*^9, 
   3.508786823253941*^9, {3.513387735967205*^9, 3.5133877365072055`*^9}, {
   3.5133974837550697`*^9, 3.5133974848950715`*^9}, {3.513804671525152*^9, 
   3.513804735354803*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5136558067487864`*^9, 3.5136558085287886`*^9}, {
   3.5136565322798023`*^9, 3.5136565328398027`*^9}, {3.513795385267009*^9, 
   3.513795386480078*^9}, {3.5137954508697615`*^9, 3.5137954512667837`*^9}, 
   3.513796189653017*^9, {3.5138063499271517`*^9, 3.5138063506981955`*^9}, {
   3.513806444070536*^9, 3.5138064560022182`*^9}, {3.5138066614379687`*^9, 
   3.5138066614379687`*^9}, {3.5138332837659206`*^9, 3.513833293061453*^9}, {
   3.5150191204886813`*^9, 3.515019133430422*^9}, {3.5152676917098017`*^9, 
   3.515267692552203*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", " ", "\[IndentingNewLine]", " ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5094830441507564`*^9, 3.5094831917952013`*^9}, {3.5094833027715483`*^9, 
   3.509483305747719*^9}, {3.509483389621516*^9, 3.5094834110637426`*^9}, {
   3.5095009204610405`*^9, 3.509500920663841*^9}, {3.509501209981949*^9, 
   3.509501254878828*^9}, {3.513803148620047*^9, 3.513803234815977*^9}, {
   3.513803272437129*^9, 3.513803274189229*^9}, {3.5138033629023037`*^9, 
   3.5138034119621096`*^9}, {3.5138034464640827`*^9, 3.5138034837682166`*^9}, 
   3.5138332738463535`*^9, {3.515183340681514*^9, 3.51518337292677*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "2"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.509483206773058*^9, 3.509483232269516*^9}, {3.509483529175498*^9, 
   3.509483565841595*^9}, {3.5094836038257675`*^9, 3.509483605101841*^9}, {
   3.5095009240490465`*^9, 3.5095009272782526`*^9}, {3.5095012643168445`*^9, 
   3.5095013143617325`*^9}, 3.5099029224730244`*^9, {3.5099334141350336`*^9, 
   3.5099334155450354`*^9}, 3.5104336477619963`*^9, 3.510551779322821*^9, 
   3.511813228736384*^9, {3.5138043779653616`*^9, 3.5138043823316116`*^9}, {
   3.5138044682855277`*^9, 3.513804528375965*^9}, {3.51380585931609*^9, 
   3.513805862448269*^9}, 3.5138063367613983`*^9, {3.513806425834493*^9, 
   3.513806436602109*^9}, {3.513806646689125*^9, 3.5138066682863607`*^9}, {
   3.5138332097796893`*^9, 3.5138332177931476`*^9}, {3.5150190880908284`*^9, 
   3.515019099917505*^9}, {3.5151833845799904`*^9, 3.515183412379239*^9}, {
   3.515267624458084*^9, 3.5152676777945776`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
    RowBox[{"m", "/", "2"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, 3.5139250407746024`*^9, {
   3.51399689977668*^9, 3.513996903801487*^9}, 3.5151833309470963`*^9, 
   3.515183596766364*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.513916690654889*^9, 3.5139166933448925`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", "/", "z"}]}]]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"z", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", "z"}]}]]}], "b"], "-", 
    FractionBox[
     RowBox[{"a", " ", "z"}], 
     RowBox[{" ", 
      RowBox[{"b", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", "/", "z"}]}]]}]}]]}]}]],
  CellChangeTimes->{{3.513916733274948*^9, 3.5139167911750298`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}, 3.5108633469910617`*^9, {
   3.5108842882102137`*^9, 3.510884343449911*^9}, {3.5108843749619665`*^9, 
   3.510884406786022*^9}, {3.513916725294937*^9, 3.5139167267249393`*^9}, {
   3.51391679832504*^9, 3.5139168017350445`*^9}, {3.5139213137293844`*^9, 
   3.5139213451294284`*^9}, 3.5139213778694744`*^9, {3.5139217981300626`*^9, 
   3.513921849840135*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", 
     RowBox[{"-", "3"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, 3.5138883567908974`*^9, {
   3.5139145994019613`*^9, 3.5139146066819715`*^9}, {3.513917889356567*^9, 
   3.513917900756583*^9}, 3.5139211089490976`*^9, {3.5139220421704044`*^9, 
   3.5139220429204054`*^9}, {3.5139976216315484`*^9, 3.5139976220995493`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "/", "2"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{
        RowBox[{"m", "/", "2"}], "+", "j"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{
        RowBox[{"m", "/", "2"}], "+", "j"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5139134911004095`*^9, 
   3.513913502070425*^9}, {3.513913704260708*^9, 3.513913873020944*^9}, {
   3.513913907730993*^9, 3.5139139106109967`*^9}, {3.513914028481162*^9, 
   3.513914030981165*^9}, {3.513914229171443*^9, 3.513914238101455*^9}, 
   3.513914542761882*^9, {3.513916297654339*^9, 3.513916328704382*^9}, {
   3.5139163677544365`*^9, 3.513916400614483*^9}, {3.513916463754571*^9, 
   3.5139164797445936`*^9}, 3.51391659143475*^9, 3.513916631264806*^9, 
   3.5139169852053013`*^9, 3.513920403770095*^9, {3.513921156349164*^9, 
   3.5139211807391987`*^9}, 3.513921224169259*^9, {3.513921262649313*^9, 
   3.5139212836893425`*^9}, 3.513921877580174*^9, {3.5139976314907656`*^9, 
   3.51399764537479*^9}, {3.515183487285372*^9, 3.515183493260182*^9}, {
   3.5151835432114697`*^9, 3.5151835476730776`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "j"}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "j"}], ")"}]}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, {3.5138883597509017`*^9, 
   3.5138884250309935`*^9}, {3.5138888699116163`*^9, 3.513888889801644*^9}, {
   3.5138924945366907`*^9, 3.51389252984674*^9}, {3.513892659376921*^9, 
   3.5138926608669233`*^9}, {3.5139003700812826`*^9, 
   3.5139003856657095`*^9}, {3.5139131128118644`*^9, 3.513913114911867*^9}, {
   3.5139132757920923`*^9, 3.513913283242103*^9}, {3.5139140972712584`*^9, 
   3.513914206441411*^9}, {3.5139143038815475`*^9, 3.5139143075315523`*^9}, {
   3.513914633592009*^9, 3.5139146431720223`*^9}, {3.5139147818822165`*^9, 
   3.513914785032221*^9}, {3.5139158452037053`*^9, 3.5139158581137233`*^9}, 
   3.513916930955225*^9, 3.5139176260461984`*^9, {3.5139178653665333`*^9, 
   3.513917880516555*^9}, {3.513922048310413*^9, 3.5139220840704627`*^9}, {
   3.5139221395005407`*^9, 3.51392216051057*^9}, 3.513922208620637*^9, 
   3.5168209560368814`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 5 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox["1", "2"]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.513916690654889*^9, 3.5139166933448925`*^9}, {
   3.5139238503329353`*^9, 3.5139239230330377`*^9}, {3.513924157173365*^9, 
   3.5139241680033803`*^9}, {3.5139620122773943`*^9, 3.513962021684211*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, 3.5138883567908974`*^9, {
   3.5139145994019613`*^9, 3.5139146066819715`*^9}, {3.513917889356567*^9, 
   3.513917900756583*^9}, 3.5139211089490976`*^9, {3.5139220421704044`*^9, 
   3.5139220429204054`*^9}, {3.5139630734440584`*^9, 
   3.5139630744112606`*^9}, {3.5139975977479067`*^9, 3.5139975977479067`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "/", "2"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"d", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "/", "2"}]], 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "/", "2"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.501815019950712*^9, 3.501815042773553*^9}, {3.504810650784292*^9, 
   3.504810652074294*^9}, {3.505355146717435*^9, 3.5053551630474577`*^9}, 
   3.5053551980875072`*^9, 3.5053635229733753`*^9, 3.5133881809878273`*^9, {
   3.513393762090927*^9, 3.5133938308270245`*^9}, {3.513393896327116*^9, 
   3.5133939132171392`*^9}, {3.513962096579942*^9, 3.5139623032239056`*^9}, {
   3.5139624829830217`*^9, 3.5139625030290565`*^9}, {3.5139627674027214`*^9, 
   3.5139628032203836`*^9}, {3.513997603473117*^9, 3.513997612817533*^9}, {
   3.51518349778419*^9, 3.515183503041399*^9}, {3.515183550621483*^9, 
   3.5151835565494933`*^9}, 3.515971707480028*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
            "m"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", "x"}],
        "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, {3.5138883597509017`*^9, 
   3.5138884250309935`*^9}, {3.5138888699116163`*^9, 3.513888889801644*^9}, {
   3.5138924945366907`*^9, 3.51389252984674*^9}, {3.513892659376921*^9, 
   3.5138926608669233`*^9}, {3.5139003700812826`*^9, 
   3.5139003856657095`*^9}, {3.5139131128118644`*^9, 3.513913114911867*^9}, {
   3.5139132757920923`*^9, 3.513913283242103*^9}, {3.5139140972712584`*^9, 
   3.513914206441411*^9}, {3.5139143038815475`*^9, 3.5139143075315523`*^9}, {
   3.513914633592009*^9, 3.5139146431720223`*^9}, {3.5139147818822165`*^9, 
   3.513914785032221*^9}, {3.5139158452037053`*^9, 3.5139158581137233`*^9}, 
   3.513916930955225*^9, 3.5139176260461984`*^9, {3.5139178653665333`*^9, 
   3.513917880516555*^9}, {3.513922048310413*^9, 3.5139220840704627`*^9}, {
   3.5139221395005407`*^9, 3.51392216051057*^9}, 3.513922208620637*^9, {
   3.5139242073634357`*^9, 3.5139242101834393`*^9}, {3.5139242758535314`*^9, 
   3.5139243179635906`*^9}, 3.5139628793329177`*^9, {3.513962932279411*^9, 
   3.5139629510774436`*^9}, {3.513962984867103*^9, 3.513963043351606*^9}, {
   3.5139647511890087`*^9, 3.5139647554790144`*^9}, {3.51396498811934*^9, 
   3.513964991919346*^9}, 3.516820958676885*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 4a with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox["1", "2"]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["3", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501897999882035*^9, 3.5018980004280357`*^9}, 3.508786823273941*^9, {
   3.5133877723772554`*^9, 3.5133877743972583`*^9}, {3.5133974922150817`*^9, 
   3.513397493415084*^9}, {3.5138806860881577`*^9, 3.513880744178239*^9}, {
   3.513891091064726*^9, 3.5138911316247826`*^9}, 3.51389118713486*^9, {
   3.513918517117446*^9, 3.513918529997464*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, 3.5138883567908974`*^9, {
   3.5139145994019613`*^9, 3.5139146066819715`*^9}, 3.5139176939662933`*^9, {
   3.513997698383683*^9, 3.513997698383683*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
     RowBox[{"m", "/", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", 
         SuperscriptBox["a", "2"], 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"d", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "/", "2"}]], 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]}], "+", 
  RowBox[{"b", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5133951012864146`*^9, 3.513395436935285*^9}, {
   3.5133955737854767`*^9, 3.51339563336556*^9}, 3.513880783048293*^9, {
   3.513880818818343*^9, 3.5138809268084946`*^9}, {3.5138809606185417`*^9, 
   3.5138810091586094`*^9}, {3.5138810413386545`*^9, 3.513881046558662*^9}, {
   3.5138811620088234`*^9, 3.513881163408826*^9}, {3.5138912012748795`*^9, 
   3.5138912079548893`*^9}, {3.5138912645349684`*^9, 3.5138913768051257`*^9}, 
   3.513891457765239*^9, {3.5139184087872944`*^9, 3.5139184204773107`*^9}, {
   3.513997677776047*^9, 3.5139976854980607`*^9}, {3.5151835116058145`*^9, 
   3.515183516083022*^9}, {3.5151835620251026`*^9, 3.5151835662995105`*^9}, 
   3.5159717247180586`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"b", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          "m"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5018980188984685`*^9, 3.50189801985007*^9}, {
   3.5018993588676224`*^9, 3.5018993591016226`*^9}, {3.501899407617708*^9, 
   3.5018994162601233`*^9}, {3.5019584349071083`*^9, 3.501958435137108*^9}, 
   3.502043281447963*^9, {3.502043836886939*^9, 3.5020438378697405`*^9}, {
   3.5020440523233175`*^9, 3.502044053150119*^9}, {3.5020452897486906`*^9, 
   3.5020452909654927`*^9}, {3.5023272013119135`*^9, 3.5023272098607283`*^9}, 
   3.5023293759713326`*^9, {3.502330255532078*^9, 3.502330260882887*^9}, {
   3.505169008467469*^9, 3.5051690099755554`*^9}, {3.505355146667435*^9, 
   3.5053551630074577`*^9}, 3.5053551980475073`*^9, 3.505363517073367*^9, 
   3.5133879210874643`*^9, {3.5133880027075777`*^9, 3.513388003137579*^9}, 
   3.5133880665876675`*^9, 3.5133881203977427`*^9, 3.5133958374610467`*^9, 
   3.5134409700670853`*^9, {3.513714974962614*^9, 3.5137149768034177`*^9}, {
   3.5138812261089134`*^9, 3.5138812634489655`*^9}, {3.5138813489190855`*^9, 
   3.5138813692991138`*^9}, {3.513881427699196*^9, 3.513881435869207*^9}, {
   3.513891575615404*^9, 3.513891650825509*^9}, {3.51391857018752*^9, 
   3.5139186101875763`*^9}, {3.513918774977807*^9, 3.513918782367817*^9}, 
   3.516820958686885*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], 
          RowBox[{"-", "1"}]]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}, 3.5108633469910617`*^9, {
   3.5108842882102137`*^9, 3.510884343449911*^9}, {3.5108843749619665`*^9, 
   3.510884406786022*^9}, {3.5139250542546215`*^9, 3.513925082944661*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], " ", "\[And]", " ", 
       SuperscriptBox["n", "2"]}], "=", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.51310511553405*^9, 3.5131051164840517`*^9}, {3.513117218830975*^9, 
   3.513117253281023*^9}, {3.5136175857465153`*^9, 3.5136175857465153`*^9}, 
   3.5138879783283663`*^9, {3.5139247299541674`*^9, 3.5139247316341696`*^9}, {
   3.5139247785042353`*^9, 3.513924785224244*^9}, {3.513925028384585*^9, 
   3.513925028534585*^9}, {3.5139971565999312`*^9, 3.513997207783621*^9}, {
   3.513997296792178*^9, 3.513997296792178*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
    RowBox[{"m", "/", "2"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "/", "2"}]], 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "/", "2"}]], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.510884665409277*^9, 
   3.5108846846441107`*^9}, {3.5139244710238047`*^9, 3.513924648744054*^9}, {
   3.5139249594844885`*^9, 3.5139249830045214`*^9}, 3.5139969530351734`*^9, {
   3.513996987402034*^9, 3.5139969981504526`*^9}, 3.5151835202014294`*^9, {
   3.515183570542718*^9, 3.5151835777967305`*^9}, 3.515971738552483*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
      "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", 
           RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"n", "^", "2"}], "\[Equal]", 
     RowBox[{"1", "/", "4"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.5108846945033283`*^9, 3.510884709728955*^9}, {
   3.5108859382627134`*^9, 3.5108859604771523`*^9}, {3.5108859926756086`*^9, 
   3.5108860292576733`*^9}, {3.510886184571546*^9, 3.5108861883623524`*^9}, {
   3.510887974909091*^9, 3.510887994721126*^9}, 3.5108890742750225`*^9, {
   3.510889110201885*^9, 3.510889185830818*^9}, {3.510889486620947*^9, 
   3.51088949379696*^9}, {3.5108962096159573`*^9, 3.510896246634823*^9}, {
   3.5108962832324867`*^9, 3.51089630206172*^9}, {3.5131048716537085`*^9, 
   3.5131048750437136`*^9}, {3.513104905483756*^9, 3.513104924053782*^9}, {
   3.513104986343869*^9, 3.513104990303875*^9}, 3.5131050388439426`*^9, 
   3.5131052037741737`*^9, 3.5131052873342905`*^9, {3.5131088938999405`*^9, 
   3.5131089717440767`*^9}, 3.5131108266281357`*^9, {3.513110873069417*^9, 
   3.5131108795278287`*^9}, {3.513110918902298*^9, 3.5131109232079053`*^9}, {
   3.5131111898903737`*^9, 3.513111191231976*^9}, {3.513117210290963*^9, 
   3.513117258801031*^9}, {3.513617561546482*^9, 3.513617563886485*^9}, {
   3.5136175985465336`*^9, 3.5136175992165346`*^9}, {3.5138879484683247`*^9, 
   3.5138880263284335`*^9}, 3.5138881845086555`*^9, {3.5138885380211515`*^9, 
   3.513888542161157*^9}, {3.5138886073712482`*^9, 3.5138886267212753`*^9}, {
   3.513888733501425*^9, 3.5138887799214897`*^9}, {3.513889050751869*^9, 
   3.5138890803219104`*^9}, {3.5138921863962593`*^9, 3.513892224576312*^9}, {
   3.513900091386793*^9, 3.5139001845033565`*^9}, {3.513918895017975*^9, 
   3.5139188980479794`*^9}, {3.5139192394384575`*^9, 3.513919240738459*^9}, {
   3.513919297588538*^9, 3.5139193618286285`*^9}, {3.513919615068983*^9, 
   3.5139196403790183`*^9}, {3.513920151089733*^9, 3.5139201769697695`*^9}, {
   3.5139205132302485`*^9, 3.5139205234502625`*^9}, {3.5139222557707033`*^9, 
   3.513922261730712*^9}, {3.513922300450766*^9, 3.513922313440784*^9}, {
   3.513924354983642*^9, 3.5139243839036827`*^9}, {3.5139247963642597`*^9, 
   3.5139249079544163`*^9}, {3.5139971190038652`*^9, 3.513997123091072*^9}, {
   3.5139973101926017`*^9, 3.513997323062624*^9}, {3.513997388286339*^9, 
   3.5139974128095818`*^9}, {3.5139974459752398`*^9, 3.5139974479720435`*^9}, 
   3.5139982253526087`*^9, 3.5168209587068853`*^9, 3.516823649532057*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"m", "/", "2"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, 3.5139250407746024`*^9, {
   3.51399689977668*^9, 3.513996903801487*^9}, {3.514000425778075*^9, 
   3.514000431487685*^9}, 3.5151828140401883`*^9, 3.515183599605569*^9, {
   3.515188585894102*^9, 3.515188588824106*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.513916690654889*^9, 3.5139166933448925`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "/", "z"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}]]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"1", "/", "z"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "b"], "-", 
    FractionBox[
     RowBox[{"a", " ", 
      SqrtBox[
       RowBox[{"1", "/", "z"}]]}], 
     RowBox[{" ", 
      RowBox[{"b", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "z"}]}]]}]}]]}]}]],
  CellChangeTimes->{{3.513916733274948*^9, 3.5139167911750298`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}, 3.5108633469910617`*^9, {
   3.5108842882102137`*^9, 3.510884343449911*^9}, {3.5108843749619665`*^9, 
   3.510884406786022*^9}, {3.513916725294937*^9, 3.5139167267249393`*^9}, {
   3.51391679832504*^9, 3.5139168017350445`*^9}, {3.5139213137293844`*^9, 
   3.5139213451294284`*^9}, 3.5139213778694744`*^9, {3.5139217981300626`*^9, 
   3.513921849840135*^9}, {3.514000735235819*^9, 3.5140007465458384`*^9}, {
   3.514000783190303*^9, 3.514000797464328*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, 3.5138883567908974`*^9, {
   3.5139145994019613`*^9, 3.5139146066819715`*^9}, {3.513917889356567*^9, 
   3.513917900756583*^9}, 3.5139211089490976`*^9, {3.5139220421704044`*^9, 
   3.5139220429204054`*^9}, {3.5139976216315484`*^9, 
   3.5139976220995493`*^9}, {3.514000856697632*^9, 3.514000863296444*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SqrtBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["1", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5139134911004095`*^9, 
   3.513913502070425*^9}, {3.513913704260708*^9, 3.513913873020944*^9}, {
   3.513913907730993*^9, 3.5139139106109967`*^9}, {3.513914028481162*^9, 
   3.513914030981165*^9}, {3.513914229171443*^9, 3.513914238101455*^9}, 
   3.513914542761882*^9, {3.513916297654339*^9, 3.513916328704382*^9}, {
   3.5139163677544365`*^9, 3.513916400614483*^9}, {3.513916463754571*^9, 
   3.5139164797445936`*^9}, 3.51391659143475*^9, 3.513916631264806*^9, 
   3.5139169852053013`*^9, 3.513920403770095*^9, {3.513921156349164*^9, 
   3.5139211807391987`*^9}, 3.513921224169259*^9, {3.513921262649313*^9, 
   3.5139212836893425`*^9}, 3.513921877580174*^9, {3.5139976314907656`*^9, 
   3.51399764537479*^9}, {3.5140005251970496`*^9, 3.514000525914651*^9}, {
   3.5140005566311045`*^9, 3.5140005712795305`*^9}, {3.514000612494803*^9, 
   3.5140006328528385`*^9}, {3.5151836072495823`*^9, 3.5151836271084175`*^9}, 
   3.5159717758929486`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, {3.5138883597509017`*^9, 
   3.5138884250309935`*^9}, {3.5138888699116163`*^9, 3.513888889801644*^9}, {
   3.5138924945366907`*^9, 3.51389252984674*^9}, {3.513892659376921*^9, 
   3.5138926608669233`*^9}, {3.5139003700812826`*^9, 
   3.5139003856657095`*^9}, {3.5139131128118644`*^9, 3.513913114911867*^9}, {
   3.5139132757920923`*^9, 3.513913283242103*^9}, {3.5139140972712584`*^9, 
   3.513914206441411*^9}, {3.5139143038815475`*^9, 3.5139143075315523`*^9}, {
   3.513914633592009*^9, 3.5139146431720223`*^9}, {3.5139147818822165`*^9, 
   3.513914785032221*^9}, {3.5139158452037053`*^9, 3.5139158581137233`*^9}, 
   3.513916930955225*^9, 3.5139176260461984`*^9, {3.5139178653665333`*^9, 
   3.513917880516555*^9}, {3.513922048310413*^9, 3.5139220840704627`*^9}, {
   3.5139221395005407`*^9, 3.51392216051057*^9}, 3.513922208620637*^9, {
   3.514000891626494*^9, 3.514000984368657*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], 
        RowBox[{"-", "1"}]]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5107881322665586`*^9, 3.5107881705866117`*^9}, {3.510788449847003*^9, 
   3.510788449847003*^9}, {3.513999325080941*^9, 3.5139993545961933`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     SuperscriptBox["n", "2"]}], "=", "1"}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5139991920127077`*^9, 3.513999212277143*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "/", "2"}]], 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 
   3.5107885379071264`*^9}, {3.5107893359082437`*^9, 3.5107893412382507`*^9}, 
   3.5107893780883026`*^9, 3.510845655897318*^9, {3.513999046698452*^9, 
   3.5139991167269754`*^9}, {3.5139997245412436`*^9, 3.513999727442848*^9}, {
   3.513999764664514*^9, 3.513999770015323*^9}, {3.5140010500603724`*^9, 
   3.5140010594203887`*^9}, {3.5151836151587963`*^9, 3.515183651023259*^9}, 
   3.5159717871249685`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", "x"}], "]"}]}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"n", "^", "2"}], "==", 
     RowBox[{"1", "/", "4"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107893516982656`*^9, 
   3.510789366068286*^9}, {3.5107896328306603`*^9, 3.5107896399606705`*^9}, {
   3.5107898766310015`*^9, 3.510789877641003*^9}, {3.5107904722018356`*^9, 
   3.5107904864718556`*^9}, {3.5107906016920166`*^9, 3.5107906035620193`*^9}, 
   3.5108133336573973`*^9, {3.510813433138772*^9, 3.5108134492536*^9}, {
   3.5108135037444963`*^9, 3.510813509516506*^9}, {3.510813560575396*^9, 
   3.5108135638826017`*^9}, {3.5108452158985453`*^9, 
   3.5108453343027534`*^9}, {3.5108456732445483`*^9, 
   3.5108456896245775`*^9}, {3.510845924108589*^9, 3.510845925356591*^9}, 
   3.5139582753849363`*^9, {3.5139991368666105`*^9, 3.5139991877851*^9}, {
   3.513999236644386*^9, 3.513999253164815*^9}, {3.513999441160745*^9, 
   3.5139994424711475`*^9}, {3.5139999345488124`*^9, 3.514000007915741*^9}, {
   3.5140010703248076`*^9, 3.5140011067040715`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "9"}], "-", "10"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, {
   3.5020844484656277`*^9, 3.502084458309245*^9}, {3.5021273878150387`*^9, 
   3.5021273919350443`*^9}, 3.5044913758574657`*^9, {3.5045902528518343`*^9, 
   3.5045902550118375`*^9}, {3.5053551626074576`*^9, 
   3.5053551626074576`*^9}, {3.5133815743685784`*^9, 3.5133815745685787`*^9}, 
   3.513383288320978*^9, 3.515183665780885*^9, {3.516574245424486*^9, 
   3.5165742457844863`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 9b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "j", " ", "k", " ", "m"}], "+", "k", "+", "2"}], "=", 
   "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, 
   3.5018140207689576`*^9, {3.5018216494891577`*^9, 3.501821669550793*^9}, {
   3.5019589809978724`*^9, 3.5019590047879057`*^9}, 3.508786823193941*^9, {
   3.513381917039058*^9, 3.513381917599059*^9}, {3.5133832247808895`*^9, 
   3.513383248330922*^9}, {3.5138781483346043`*^9, 3.5138781760846434`*^9}}],

Cell[TextData[{
 "Rule 9a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"2", " ", "j", " ", "k", " ", "m"}], "+", "k", "+", "2"}]}], 
      "=", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501814100266697*^9, 3.501814101436699*^9}, {
   3.5018211471994753`*^9, 3.5018211608651*^9}, {3.5019567113246946`*^9, 
   3.5019567122046957`*^9}, {3.5019609003705597`*^9, 
   3.5019609003705597`*^9}, {3.5045902588418427`*^9, 3.504590260491845*^9}, 
   3.5133832200608826`*^9, {3.513383257040934*^9, 3.5133832666409473`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", "a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], 
            "k"]}]}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501265980199109*^9, 3.501266014289157*^9}, {3.501266063349225*^9, 
   3.501266065199228*^9}, {3.501806833780734*^9, 3.5018069301109033`*^9}, {
   3.5018140261197667`*^9, 3.501814055104618*^9}, {3.501821207696382*^9, 
   3.5018212278204174`*^9}, {3.501821280220909*^9, 3.5018213326838017`*^9}, 
   3.501821441587593*^9, {3.501958758637561*^9, 3.501958830467662*^9}, {
   3.5019588709877186`*^9, 3.501958892937749*^9}, {3.5053551462074347`*^9, 
   3.5053551626174574`*^9}, 3.505355197697507*^9, 3.5053631315728273`*^9, {
   3.513383148210782*^9, 3.5133831756808205`*^9}, {3.513383362671082*^9, 
   3.5133833738110976`*^9}, {3.515183667949289*^9, 3.515183672176896*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", "a", "*", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], 
      ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "k", "+", "2"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018141043227043`*^9, 3.501814105757907*^9}, {3.501814151294387*^9, 
   3.5018141515595875`*^9}, {3.5018142482173567`*^9, 
   3.5018142526009645`*^9}, {3.501821489386077*^9, 3.501821495532488*^9}, {
   3.501821564203808*^9, 3.5018216013942738`*^9}, {3.5018781452436633`*^9, 
   3.501878146403665*^9}, {3.501958737877532*^9, 3.5019587381275325`*^9}, 
   3.501960814130439*^9, {3.501960853370494*^9, 3.501960895000552*^9}, {
   3.505167695348363*^9, 3.5051676992795877`*^9}, {3.50516991570436*^9, 
   3.5051699187795362`*^9}, {3.5053551462274346`*^9, 3.5053551626274576`*^9}, 
   3.505355197707507*^9, 3.505363161352869*^9, {3.513383094770707*^9, 
   3.5133831100007286`*^9}, {3.513383193300845*^9, 3.513383213240873*^9}, {
   3.513383309251007*^9, 3.513383309811008*^9}, 3.5168208089466753`*^9, {
   3.5168325733864717`*^9, 3.51683257719569*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 4b with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, 
   3.5018140207689576`*^9, {3.5018216494891577`*^9, 3.501821669550793*^9}, {
   3.5019589809978724`*^9, 3.5019590047879057`*^9}, {3.502135717824956*^9, 
   3.50213572018056*^9}, {3.5021366778942423`*^9, 3.5021366795166454`*^9}, {
   3.5021369861631837`*^9, 3.5021369923407946`*^9}, 3.508786823203941*^9, {
   3.5133819093490477`*^9, 3.513381909829048*^9}, {3.513721165357891*^9, 
   3.513721166886694*^9}, {3.5137215035040846`*^9, 3.513721526170924*^9}, {
   3.5137217266780767`*^9, 3.513721727068077*^9}}],

Cell[TextData[{
 "Rule 9b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", "  ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", "  ", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "j", " ", "k", " ", "m"}], "+", "k", "+", "2"}], 
       "\[NotEqual]", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501881120717829*^9, 3.501881120717829*^9}, {
   3.5021348082093573`*^9, 3.502134808926959*^9}, {3.5021366244641485`*^9, 
   3.502136624932149*^9}, {3.504590263501849*^9, 3.5045902645218506`*^9}, {
   3.5133829162704573`*^9, 3.513382916840458*^9}, 3.513383037000626*^9, {
   3.513722080155098*^9, 3.5137220817931013`*^9}, {3.5138817088095894`*^9, 
   3.5138817177896013`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"2", "a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], ")"}], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "j", " ", "k", " ", "m"}], "+", "k", "+", "2"}], 
      ")"}]}], 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5133820956293087`*^9, 3.5133821557793922`*^9}, {
   3.5133821934394455`*^9, 3.513382203399459*^9}, {3.513382255339532*^9, 
   3.5133823172596183`*^9}, {3.513382376639702*^9, 3.5133823996997337`*^9}, 
   3.5133825236299076`*^9, {3.5133825769499817`*^9, 3.5133826123800316`*^9}, {
   3.5133826518700867`*^9, 3.5133826522500877`*^9}, {3.5133827327802005`*^9, 
   3.513382737710207*^9}, {3.5151836768413043`*^9, 3.515183684110917*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.502134774372898*^9, 3.5021347791621065`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "a", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "k", "+", "1"}], 
         ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], 
       ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "k", "+", "2"}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "k", "+", "1"}],
            ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "k", "+", "2"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5021347842009153`*^9, 
   3.5021347975545387`*^9}, {3.5021349097187357`*^9, 3.502134918345551*^9}, {
   3.502135766793442*^9, 3.5021357677294436`*^9}, 3.5021358320639563`*^9, {
   3.5021365249983735`*^9, 3.5021365368543944`*^9}, {3.505167706240986*^9, 
   3.5051677121233225`*^9}, {3.50516992199572*^9, 3.5051699249498887`*^9}, {
   3.505355146257435*^9, 3.5053551626474576`*^9}, 3.505355197737507*^9, 
   3.5053631681528783`*^9, 3.513382826090331*^9, {3.513382900420435*^9, 
   3.513382921280464*^9}, {3.5133829789605446`*^9, 3.5133829865005555`*^9}, 
   3.5133830206706033`*^9, {3.5133871671964083`*^9, 3.513387169866412*^9}, {
   3.5137220851159067`*^9, 3.5137220864419093`*^9}, 3.513722129575985*^9, {
   3.513881725099612*^9, 3.513881743169637*^9}, 3.5168208089766755`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, 
   3.5018140207689576`*^9, {3.5018216494891577`*^9, 3.501821669550793*^9}, {
   3.5019589809978724`*^9, 3.5019590047879057`*^9}, {3.502135717824956*^9, 
   3.50213572018056*^9}, {3.5021366778942423`*^9, 3.5021366795166454`*^9}, {
   3.5021369861631837`*^9, 3.5021369923407946`*^9}, 3.508786823203941*^9, {
   3.5133819093490477`*^9, 3.513381909829048*^9}, {3.513721165357891*^9, 
   3.513721166886694*^9}, {3.5137215035040846`*^9, 3.513721526170924*^9}}],

Cell[TextData[{
 "Rule 10: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "j", " ", "m"}], "+", "1"}], "\[NotEqual]", "0"}], 
      " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "1"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "2"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501881120717829*^9, 3.501881120717829*^9}, {
   3.5021348082093573`*^9, 3.502134808926959*^9}, {3.502136614542531*^9, 
   3.5021366198777404`*^9}, {3.502578761094302*^9, 3.502578768184312*^9}, {
   3.504590267471855*^9, 3.5045902684518566`*^9}, {3.51338404684204*^9, 
   3.513384067112068*^9}, {3.5133841050421214`*^9, 3.513384106712124*^9}, {
   3.513641759537236*^9, 3.5136417732872553`*^9}, {3.5150068450185647`*^9, 
   3.5150068472746935`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", " ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"]}], 
        RowBox[{"d", " ", "k", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "j", " ", "m"}], "+", "1"}], ")"}], " ", 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "1"}], ")"}]}], 
    RowBox[{"b", " ", "k", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "j", " ", "m"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501265980199109*^9, 3.501266014289157*^9}, {3.501266063349225*^9, 
   3.501266065199228*^9}, {3.501806833780734*^9, 3.5018069301109033`*^9}, {
   3.5021342020030923`*^9, 3.5021342253563333`*^9}, {3.502134496879611*^9, 
   3.502134506224027*^9}, {3.5021346420222654`*^9, 3.502134643972269*^9}, {
   3.50213470708998*^9, 3.502134710818386*^9}, 3.5021348366950073`*^9, {
   3.5021357367789893`*^9, 3.5021357488534107`*^9}, {3.5021361747965584`*^9, 
   3.5021361839693747`*^9}, {3.5021362308162565`*^9, 
   3.5021363518724694`*^9}, {3.502136399187352*^9, 3.5021364054429636`*^9}, {
   3.502155753065427*^9, 3.5021557599754367`*^9}, {3.505355146277435*^9, 
   3.5053551626574574`*^9}, 3.505355197747507*^9, 3.505363171332883*^9, {
   3.5133834827112503`*^9, 3.5133835194913015`*^9}, 3.513383581761389*^9, {
   3.5133836127114325`*^9, 3.513383628101454*^9}, {3.51338366818151*^9, 
   3.51338366856151*^9}, {3.513383705491562*^9, 3.513383739051609*^9}, {
   3.513383795581688*^9, 3.51338379688169*^9}, 3.513383894911827*^9, {
   3.513641493446864*^9, 3.513641502866877*^9}, {3.5136415429469333`*^9, 
   3.5136415504069433`*^9}, {3.5151836878861237`*^9, 3.515183694718936*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.502134774372898*^9, 3.5021347791621065`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "b", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "k", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "j", "*", "m"}], "+", "1"}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], 
       ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "k", "-", "1"}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "k", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "j", "*", "m"}], "+", "1"}], ")"}]}], ")"}]}]}],
       ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], "]"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "j", "*", "m"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5021347842009153`*^9, 
   3.5021347975545387`*^9}, {3.5021349097187357`*^9, 3.502134918345551*^9}, {
   3.502135766793442*^9, 3.5021357677294436`*^9}, 3.5021358320639563`*^9, 
   3.502136487651908*^9, {3.5021365295847816`*^9, 3.5021365596460342`*^9}, {
   3.5021557720954533`*^9, 3.5021557767554603`*^9}, 3.5025787020042195`*^9, {
   3.5051677206078076`*^9, 3.50516772518707*^9}, {3.505169931733277*^9, 
   3.5051699345434375`*^9}, {3.5053551462874346`*^9, 3.505355162677458*^9}, 
   3.5053551977675066`*^9, 3.5053631744528875`*^9, 3.5133834210111637`*^9, {
   3.5133840301120167`*^9, 3.513384071992075*^9}, {3.513384124552149*^9, 
   3.513384136052165*^9}, {3.5133871766164217`*^9, 3.5133871785864244`*^9}, {
   3.5136415171968975`*^9, 3.5136415219169035`*^9}, {3.5136415588569555`*^9, 
   3.513641613747032*^9}, {3.513641697437149*^9, 3.513641741367211*^9}, {
   3.5150068363300676`*^9, 3.515006839054223*^9}, 3.5168208090066757`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "13"}], "-", "14"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "3"}], "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5023422929020205`*^9, 3.502342295008024*^9}, {
   3.5025708612849264`*^9, 3.502570865774933*^9}, 3.502576943561758*^9, {
   3.5044916442778416`*^9, 3.50449165719786*^9}, {3.5046313093145866`*^9, 
   3.5046313116389904`*^9}, {3.5051789810963964`*^9, 
   3.5051789830985107`*^9}, {3.5053551627274575`*^9, 
   3.5053551627374573`*^9}, {3.513381576538582*^9, 3.513381576728582*^9}, {
   3.5133876287170544`*^9, 3.513387633377061*^9}, {3.5151837809558873`*^9, 
   3.5151838058847313`*^9}, {3.515275475010677*^9, 3.5152754771478806`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 5 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "3"}], "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, 
   3.501815012259899*^9, {3.502380812270746*^9, 3.5023808271375723`*^9}, 
   3.508786823223941*^9, {3.5133862496551237`*^9, 3.5133862518551273`*^9}, 
   3.513386362635282*^9, {3.5133870689362707`*^9, 3.513387070036272*^9}, {
   3.513884546843562*^9, 3.513884561313583*^9}}],

Cell[TextData[{
 "Rule 13: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "3"}], "2"]}]}], "=", 
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{"n", ">", 
        RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018152969603987`*^9, 
   3.5018152976624002`*^9}, {3.5019631527037125`*^9, 3.501963154183715*^9}, {
   3.5019697498310204`*^9, 3.5019697498310204`*^9}, {3.502045984589511*^9, 
   3.502045984589511*^9}, {3.502319396821365*^9, 3.5023194100189877`*^9}, {
   3.5023296064929376`*^9, 3.502329608474141*^9}, {3.5023339013540816`*^9, 
   3.5023339013540816`*^9}, {3.5023808428936*^9, 3.5023808578540263`*^9}, {
   3.502387153199114*^9, 3.5023871569091187`*^9}, {3.5023875321496444`*^9, 
   3.5023875429896593`*^9}, {3.5025903524142356`*^9, 3.502590353344237*^9}, {
   3.5046317754366*^9, 3.504631776736602*^9}, {3.5051789765201344`*^9, 
   3.505178976724146*^9}, 3.513386621685645*^9, 3.513386978486144*^9, {
   3.5133870236962075`*^9, 3.5133870242662086`*^9}, {3.5152716203387046`*^9, 
   3.515271631851525*^9}, {3.515271794887411*^9, 3.515271796650214*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095542513719344`*^9, 3.509554323542035*^9}, {3.510172539341531*^9, 
   3.5101725420403357`*^9}, {3.510173494983609*^9, 3.5101735152636447`*^9}, {
   3.5132798504870043`*^9, 3.5132799133070927`*^9}, {3.5132800310872574`*^9, 
   3.5132800316472583`*^9}, {3.5132800984573517`*^9, 
   3.5132801027073574`*^9}, {3.513280379307745*^9, 3.513280408807786*^9}, {
   3.513386309215207*^9, 3.5133863342252426`*^9}, {3.513386379485306*^9, 
   3.5133864046153407`*^9}, {3.5133864604854193`*^9, 3.513386501665477*^9}, {
   3.5151837862598968`*^9, 3.5151837880539*^9}, {3.5151838220151596`*^9, 
   3.515183823949563*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501815056251976*^9, 3.5018150914456377`*^9}, {3.501962084402217*^9, 
   3.5019620853222184`*^9}, 3.501963123453672*^9, {3.5019632157938013`*^9, 
   3.5019632266338167`*^9}, {3.5019697456010146`*^9, 
   3.5019697463110156`*^9}, {3.502045976461897*^9, 3.5020459805959044`*^9}, {
   3.502319372422922*^9, 3.502319379942135*^9}, {3.502328155378389*^9, 
   3.502328170448015*^9}, {3.502333890215662*^9, 3.502333891229664*^9}, {
   3.50238097939384*^9, 3.502380998316673*^9}, {3.502384119951358*^9, 
   3.502384122447362*^9}, {3.5023871157790613`*^9, 3.502387119649067*^9}, {
   3.5023874766895666`*^9, 3.502387488129583*^9}, {3.502577597912674*^9, 
   3.5025775992826757`*^9}, {3.5025898549735394`*^9, 3.502589858803544*^9}, {
   3.505355146387435*^9, 3.5053551627574577`*^9}, 3.505355197837507*^9, 
   3.5053633721431637`*^9, {3.5133866368756657`*^9, 3.513386664915705*^9}, {
   3.513386988946159*^9, 3.513387044006236*^9}, {3.513387130576357*^9, 
   3.5133871409963717`*^9}, {3.513635200268053*^9, 3.5136352131780715`*^9}, 
   3.513966724441771*^9, {3.513967574204962*^9, 3.51396757986497*^9}, 
   3.513967677835107*^9, {3.513968835726728*^9, 3.513968836006728*^9}, 
   3.5139691484971657`*^9, {3.51527078678764*^9, 3.5152707870840406`*^9}, {
   3.515271596111862*^9, 3.5152715998402686`*^9}, 3.5152717847785935`*^9, 
   3.5168208088166757`*^9, 3.516823655631406*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 6 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "3"}], "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, 3.5018151793673925`*^9, {
   3.5023896675526342`*^9, 3.5023896736726427`*^9}, 3.508786823233941*^9, {
   3.5133862622151413`*^9, 3.513386263035143*^9}, 3.51338728269657*^9, {
   3.5138846465537024`*^9, 3.513884658783719*^9}}],

Cell[TextData[{
 "Rule 14: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "3"}], "2"]}]}], "=", 
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "1"}], " ", 
       "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "2"}], " ", 
       "\[And]", " ", 
       RowBox[{"n", "<", 
        RowBox[{"-", "1"}]}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.50181529162519*^9, 3.5018152927015915`*^9}, {
   3.5019635541242747`*^9, 3.501963558874282*^9}, {3.5019652763866863`*^9, 
   3.5019652763866863`*^9}, {3.501985346137437*^9, 3.5019853551474495`*^9}, {
   3.5023187886386967`*^9, 3.502318789403098*^9}, {3.5023296895162835`*^9, 
   3.5023297015595045`*^9}, {3.5023316517677307`*^9, 
   3.5023316517677307`*^9}, {3.502333862822014*^9, 3.502333863555215*^9}, {
   3.5023886706912384`*^9, 3.5023886706912384`*^9}, {3.5023900266131363`*^9, 
   3.5023900266131363`*^9}, {3.5034415946084056`*^9, 
   3.5034415993196135`*^9}, {3.5046317805166073`*^9, 3.504631781636609*^9}, {
   3.5051789787322607`*^9, 3.505178979041279*^9}, 3.5133872857065744`*^9, 
   3.513387396016729*^9, 3.513387577226982*^9, {3.5152633655998006`*^9, 
   3.5152633655998006`*^9}, {3.5152641318887463`*^9, 
   3.5152641318887463`*^9}, {3.5152658658921947`*^9, 3.5152658681385984`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.513292062852798*^9, 3.513292242867111*^9}, {
   3.5132923801169157`*^9, 3.5132923861569242`*^9}, {3.5133872486165223`*^9, 
   3.5133873715566945`*^9}, {3.515183828754371*^9, 3.515183834339181*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.501815185950604*^9, 3.501815193859818*^9}, 
   3.5018153663025208`*^9, {3.501963510624214*^9, 3.5019635224342303`*^9}, {
   3.5019853143173923`*^9, 3.501985331897417*^9}, {3.5023186901245236`*^9, 
   3.5023186995781403`*^9}, {3.502328108500306*^9, 3.5023281359095545`*^9}, {
   3.502329683447873*^9, 3.502329705787112*^9}, 3.502329766050018*^9, {
   3.5023316434061155`*^9, 3.5023316474465227`*^9}, {3.5023338521983953`*^9, 
   3.5023338551468005`*^9}, 3.502388666141232*^9, {3.5023898041128254`*^9, 
   3.5023898144828396`*^9}, {3.5023899130529776`*^9, 3.5023899145029793`*^9}, 
   3.502389976893067*^9, {3.503441572861967*^9, 3.503441583563586*^9}, {
   3.505355146427435*^9, 3.5053551627874575`*^9}, 3.505355197867507*^9, 
   3.505363377323171*^9, {3.5133873851267138`*^9, 3.513387429826776*^9}, 
   3.5133875550169516`*^9, {3.513635168298009*^9, 3.513635193838044*^9}, 
   3.5139667527218103`*^9, {3.5139676701850967`*^9, 3.5139676725050993`*^9}, 
   3.513969150447169*^9, 3.5139694052075253`*^9, {3.5139698028780823`*^9, 
   3.513969810508093*^9}, {3.5152579365933313`*^9, 3.515257939058135*^9}, {
   3.5152588102728653`*^9, 3.5152588119108686`*^9}, {3.5152632960236783`*^9, 
   3.515263299486884*^9}, 3.5152640720782413`*^9, {3.5152658551749754`*^9, 
   3.51526585740578*^9}, 3.515270649663399*^9, 3.516820808846676*^9, 
   3.5168236556354055`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "11"}], "-", "12"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5023422929020205`*^9, 3.502342295008024*^9}, {
   3.5025708612849264`*^9, 3.502570865774933*^9}, 3.502576943561758*^9, 
   3.502577083881954*^9, {3.5044914877476225`*^9, 3.504491489617625*^9}, {
   3.504631304447378*^9, 3.504631306631382*^9}, {3.5051789569920177`*^9, 
   3.5051789589731307`*^9}, {3.505355162677458*^9, 3.505355162677458*^9}, {
   3.51338157550858*^9, 3.5133815756785803`*^9}, {3.5133846353528643`*^9, 
   3.5133846725829163`*^9}, {3.5139674218947487`*^9, 
   3.5139674230147505`*^9}, {3.5151837139537697`*^9, 
   3.5151837321122017`*^9}, {3.5151837953235126`*^9, 
   3.5151837977727165`*^9}, {3.5152754685522656`*^9, 3.5152754711262703`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 4b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "1"}], "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, 
   3.5018140207689576`*^9, {3.5018216494891577`*^9, 3.501821669550793*^9}, 
   3.508786823203941*^9, {3.513384184712233*^9, 3.513384185612234*^9}, 
   3.513384393252525*^9, {3.5133845883627977`*^9, 3.5133845898028*^9}, {
   3.5138783559248953`*^9, 3.513878367924912*^9}}],

Cell[TextData[{
 "Rule 11: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}]}], "=", 
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", 
        FractionBox["1", "2"]}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501814100266697*^9, 3.501814101436699*^9}, {
   3.5018211471994753`*^9, 3.5018211608651*^9}, {3.5019567113246946`*^9, 
   3.5019567122046957`*^9}, {3.501964142785099*^9, 3.501964142785099*^9}, {
   3.5023828502435265`*^9, 3.502382861350746*^9}, {3.5023829285400643`*^9, 
   3.502382935248076*^9}, {3.502384259649603*^9, 3.502384271505624*^9}, {
   3.5023843089768896`*^9, 3.5023843119876947`*^9}, {3.5023869181887846`*^9, 
   3.5023869194787865`*^9}, {3.5023871694491367`*^9, 
   3.5023871721091404`*^9}, {3.5024211796860027`*^9, 3.502421187536014*^9}, {
   3.5025882738113256`*^9, 3.502588275051327*^9}, {3.504631736677337*^9, 
   3.5046317376913385`*^9}, {3.50517896141127*^9, 3.5051789616042814`*^9}, 
   3.5133844008125353`*^9, 3.5133846049828215`*^9, {3.513384964233324*^9, 
   3.513384964783325*^9}, {3.5133858462445593`*^9, 3.51338584696456*^9}, {
   3.5133858927146244`*^9, 3.513385893394625*^9}, {3.513967475764824*^9, 
   3.51396747983483*^9}, {3.5152716429743443`*^9, 3.5152716513359594`*^9}, {
   3.515271803451826*^9, 3.5152718053082294`*^9}, {3.516832992131423*^9, 
   3.516832992131423*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "-", "1"}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.513384265162346*^9, 3.5133842957523885`*^9}, {
   3.513384352622468*^9, 3.513384370672493*^9}, {3.513384416302557*^9, 
   3.513384421772565*^9}, {3.5133844529026084`*^9, 3.513384537802727*^9}, {
   3.5151837362774086`*^9, 3.51518374247062*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "/", "n"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018141043227043`*^9, 3.501814105757907*^9}, {3.501814151294387*^9, 
   3.5018141515595875`*^9}, {3.5018142482173567`*^9, 
   3.5018142526009645`*^9}, {3.501821489386077*^9, 3.501821495532488*^9}, {
   3.501821564203808*^9, 3.5018216013942738`*^9}, {3.5018781452436633`*^9, 
   3.501878146403665*^9}, {3.50195874362754*^9, 3.5019587438675404`*^9}, 
   3.501986567309147*^9, {3.5023199067862606`*^9, 3.502319910561467*^9}, {
   3.5023383978591795`*^9, 3.5023384021803865`*^9}, {3.5023828123354607`*^9, 
   3.5023828129750614`*^9}, {3.5023829127372365`*^9, 
   3.5023829198196487`*^9}, {3.502384187546276*^9, 3.502384244345976*^9}, {
   3.5023848097533693`*^9, 3.5023848139809766`*^9}, {3.502386659168422*^9, 
   3.5023866594584227`*^9}, {3.5023871036790447`*^9, 3.502387106689049*^9}, {
   3.5024211967560267`*^9, 3.502421199916031*^9}, {3.505355146317435*^9, 
   3.5053551627074575`*^9}, 3.505355197787507*^9, 3.5053632706030216`*^9, 
   3.513384695132948*^9, {3.5133847266529913`*^9, 3.5133847435630155`*^9}, 
   3.5133847999530945`*^9, {3.5133848329731407`*^9, 3.513384944553297*^9}, {
   3.5133858368845463`*^9, 3.5133858416245527`*^9}, 3.5133859082946463`*^9, {
   3.5133871514863863`*^9, 3.51338715408639*^9}, {3.5136352561081314`*^9, 
   3.5136353017881956`*^9}, 3.513966580111569*^9, {3.5139674256147537`*^9, 
   3.5139674437947793`*^9}, {3.5139674838748355`*^9, 
   3.5139674918248463`*^9}, {3.513968831496722*^9, 3.5139688318467226`*^9}, {
   3.5139691380571513`*^9, 3.513969141517156*^9}, {3.5152707702360106`*^9, 
   3.5152707757116203`*^9}, {3.515271574193824*^9, 3.5152715817130365`*^9}, {
   3.515271773062973*^9, 3.5152717746853757`*^9}, 3.5168208088766756`*^9, 
   3.5168236556674075`*^9, {3.5168329442686853`*^9, 3.5168329474198656`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
    FractionBox[
     RowBox[{"k", "+", "1"}], "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, 3.501814332956706*^9, 3.5018217188156796`*^9, 
   3.508786823213941*^9, {3.51338421101227*^9, 3.5133842114922705`*^9}, 
   3.5133851484435825`*^9, {3.5133859873647566`*^9, 3.5133859886947584`*^9}, {
   3.51387844517502*^9, 3.513878456355036*^9}}],

Cell[TextData[{
 "Rule 12: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}]}], "=", 
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "1"}], " ", 
       "\[And]", " ", 
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "2"}], " ", 
       "\[And]", " ", 
       RowBox[{"n", "<", 
        RowBox[{"-", "1"}]}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5023395510912046`*^9, 
   3.5023395726972427`*^9}, {3.502382141867082*^9, 3.502382142990284*^9}, {
   3.5023888311514626`*^9, 3.502388833891467*^9}, {3.50239037931363*^9, 
   3.502390384843638*^9}, {3.503441151311346*^9, 3.5034411637713633`*^9}, {
   3.5046317436349497`*^9, 3.5046317449141517`*^9}, {3.505178963915414*^9, 
   3.5051789642284317`*^9}, 3.5133855970042105`*^9, {3.5133856773043222`*^9, 
   3.5133856957343483`*^9}, {3.513385942374694*^9, 3.513385943174695*^9}, {
   3.515264103091096*^9, 3.5152641108287096`*^9}, {3.515265877763815*^9, 
   3.5152658825686235`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.513385066983468*^9, 3.5133851251535497`*^9}, {
   3.513385173283617*^9, 3.5133852087836666`*^9}, {3.51338528269377*^9, 
   3.5133853036937995`*^9}, {3.513385355213872*^9, 3.513385371353894*^9}, {
   3.515183747961829*^9, 3.515183753515439*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5023203430722265`*^9, 3.502320347268634*^9}, {
   3.502338777969447*^9, 3.502338810495504*^9}, 3.5023394935115037`*^9, {
   3.5023395359435787`*^9, 3.502339538595583*^9}, {3.502382132382265*^9, 
   3.50238213523707*^9}, {3.502388816831443*^9, 3.5023888192114463`*^9}, {
   3.5023903157235413`*^9, 3.502390319073546*^9}, {3.5034411299313164`*^9, 
   3.503441139031329*^9}, {3.5053551463574347`*^9, 3.5053551627274575`*^9}, 
   3.505355197817507*^9, 3.5053632753930283`*^9, 3.513385564574165*^9, {
   3.5133856066042233`*^9, 3.5133856606742992`*^9}, {3.513385701234356*^9, 
   3.5133857025043583`*^9}, {3.5133859285246744`*^9, 
   3.5133859308546777`*^9}, {3.5136352711481524`*^9, 3.5136352837281704`*^9}, 
   3.5139665871815786`*^9, 3.5139667048917437`*^9, 3.513969146547163*^9, 
   3.513969400057518*^9, 3.5139698182181034`*^9, {3.515257928231716*^9, 
   3.515257930852521*^9}, {3.5152588004292483`*^9, 3.515258802582052*^9}, {
   3.5152632845264587`*^9, 3.5152632891284666`*^9}, {3.5152639723160667`*^9, 
   3.515263981629283*^9}, {3.5152658398245487`*^9, 3.5152658420553527`*^9}, 
   3.5152706429709873`*^9, 3.5168208089166756`*^9, 3.5168236557014093`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "7"}], "-", "8"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, 3.513605913762121*^9, 
   3.513795251900381*^9, {3.513805960417873*^9, 3.5138059633160386`*^9}, {
   3.513833340295154*^9, 3.513833340514167*^9}, 3.5151828059125743`*^9, {
   3.515182972630067*^9, 3.5151829756096725`*^9}, 3.5165791139673195`*^9, {
   3.516579773498243*^9, 3.5165797789482503`*^9}, {3.5165801987488384`*^9, 
   3.516580200668841*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.555.?", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976406080004325`*^9, 
   3.4976407686675158`*^9, {3.4976412761676073`*^9, 3.497641276370407*^9}, {
   3.4976413811245914`*^9, 3.4976414279246736`*^9}, 3.4976415918497615`*^9, {
   3.497924019318006*^9, 3.4979240196144066`*^9}, {3.498241234894184*^9, 
   3.4982412543042116`*^9}, 3.504589662077794*^9, {3.5165796831181164`*^9, 
   3.5165797012081413`*^9}}],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 
   3.5017335953768063`*^9}, {3.501733875319298*^9, 3.501733886769718*^9}, 
   3.5087868231739407`*^9, {3.513883533542144*^9, 3.5138835815022106`*^9}, {
   3.5138838785526266`*^9, 3.513883898882655*^9}, {3.5138844660034494`*^9, 
   3.51388446672345*^9}, {3.51657805700584*^9, 3.516578065425852*^9}}],

Cell[TextData[{
 "Rule 7: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, 
   3.4982412736942387`*^9, {3.503449288357001*^9, 3.5034492910090055`*^9}, {
   3.504589596062498*^9, 3.504589602782508*^9}, {3.5045900841715984`*^9, 
   3.504590086031601*^9}, {3.5136180641471853`*^9, 3.5136180649371867`*^9}, {
   3.514145465634817*^9, 3.514145465634817*^9}, 3.516578098155897*^9, {
   3.516579786628261*^9, 3.516579787068262*^9}, {3.5165799465484853`*^9, 
   3.5165799470384855`*^9}, 3.5165802572589197`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         FractionBox[
          RowBox[{"k", "-", "1"}], "2"]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, 3.497640636985284*^9, {3.49764069135378*^9, 
   3.4976406986701927`*^9}, {3.497640801957974*^9, 3.497640818119602*^9}, {
   3.4976415480136843`*^9, 3.497641558013302*^9}, {3.4976416100549936`*^9, 
   3.4976416105853944`*^9}, {3.4979216146205826`*^9, 3.4979216448222356`*^9}, 
   3.4979239295710487`*^9, {3.5053551461074343`*^9, 3.5053551625774574`*^9}, 
   3.5053551976175065`*^9, 3.5053628749424677`*^9, {3.5133794606456194`*^9, 
   3.5133794610156198`*^9}, 3.513379498895673*^9, {3.5151820312260127`*^9, 
   3.515182034798419*^9}, {3.5165776638252892`*^9, 3.5165776818253145`*^9}, {
   3.516577719195367*^9, 3.516577782755456*^9}, 3.516577813575499*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, {3.4979216146205826`*^9, 3.4979216448378353`*^9}, 
   3.497923923643038*^9, {3.4982412812142496`*^9, 3.4982412833342524`*^9}, {
   3.5023216899473925`*^9, 3.502321690259393*^9}, {3.5045895838424816`*^9, 
   3.5045895881124873`*^9}, {3.5053551461274347`*^9, 3.5053551625874577`*^9}, 
   3.5053551976375065`*^9, 3.505362881322477*^9, {3.513379488585658*^9, 
   3.513379494735667*^9}, 3.514145459054808*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "/", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, {3.513656934580365*^9, 3.513656989690442*^9}, {
   3.513657056540536*^9, 3.5136570847905755`*^9}, {3.5136572776408453`*^9, 
   3.513657278700847*^9}, 3.513795095427431*^9, {3.5137954552880135`*^9, 
   3.513795485066717*^9}, {3.5137955829433155`*^9, 3.513795587814594*^9}, {
   3.5137956180853252`*^9, 3.513795623374628*^9}, 3.5137961784413757`*^9, {
   3.513833113343173*^9, 3.513833163672052*^9}, {3.5151828723062906`*^9, 
   3.5151828755354967`*^9}, {3.515183078460653*^9, 3.515183083483862*^9}, {
   3.5151834395232873`*^9, 3.515183444359296*^9}, {3.5165781584359818`*^9, 
   3.516578160135984*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.555.? inverted", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, 3.497583103771538*^9, 
   3.4979235780400314`*^9, {3.498240948743784*^9, 3.4982409612938013`*^9}, {
   3.5045896721978087`*^9, 3.5045896726178093`*^9}, {3.5165796775681086`*^9, 
   3.5165797222881713`*^9}}],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 3.5017335953768063`*^9}, 
   3.508786823183941*^9, {3.5138842955432105`*^9, 3.513884350713288*^9}, {
   3.5138844713934565`*^9, 3.5138844716834574`*^9}, {3.516578653306675*^9, 
   3.516578656026678*^9}}],

Cell[TextData[{
 "Rule 8: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"n", "\[NotEqual]", 
      FractionBox["1", "2"]}], " ", "\[And]", " ", 
     RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
     RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.49824098175383*^9, 3.4982410100538692`*^9}, {
   3.501806521764586*^9, 3.501806522825388*^9}, {3.5043673081970787`*^9, 
   3.5043673130770855`*^9}, {3.504589937681393*^9, 3.5045899401413965`*^9}, {
   3.504590096691616*^9, 3.5045900978716173`*^9}, {3.513618073827199*^9, 
   3.5136180745271997`*^9}, {3.514145798415283*^9, 3.514145798415283*^9}, {
   3.5141534525486174`*^9, 3.51415345975583*^9}, {3.5165786695766973`*^9, 
   3.5165786740467033`*^9}, {3.516579783398257*^9, 3.5165797839482574`*^9}, {
   3.516579949528489*^9, 3.5165799503584905`*^9}, 3.5165802603489246`*^9, {
   3.5168328599368615`*^9, 3.516832866074213*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "-", "1"}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.497923590660453*^9, {3.5053551461774344`*^9, 3.505355162597458*^9}, 
   3.5053551976675067`*^9, 3.505362939562558*^9, {3.513379512025691*^9, 
   3.513379515495696*^9}, {3.5151820485888433`*^9, 3.515182051927249*^9}, {
   3.5165785415965185`*^9, 3.516578588456584*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "/", "n"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.497923569444416*^9, {3.4982410296338973`*^9, 3.4982410322139006`*^9}, 
   3.501806517926979*^9, {3.504367290927055*^9, 3.5043672999870677`*^9}, {
   3.504589927381379*^9, 3.50458992787138*^9}, {3.505355146187434*^9, 
   3.5053551626074576`*^9}, 3.5053551976875067`*^9, 3.505362943012563*^9, {
   3.5133795214257045`*^9, 3.513379523885708*^9}, {3.514145770335244*^9, 
   3.514145770585244*^9}, 3.5141534394757943`*^9, {3.516578784936859*^9, 
   3.5165787866568613`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "/", "n"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, {3.513656934580365*^9, 3.513656989690442*^9}, {
   3.513657056540536*^9, 3.5136570847905755`*^9}, {3.5136572776408453`*^9, 
   3.513657278700847*^9}, 3.513795095427431*^9, {3.5137954552880135`*^9, 
   3.513795485066717*^9}, {3.5137955829433155`*^9, 3.513795587814594*^9}, {
   3.5137956180853252`*^9, 3.513795623374628*^9}, 3.5137961784413757`*^9, {
   3.5138335128840256`*^9, 3.5138335495821247`*^9}, {3.5138335824210033`*^9, 
   3.5138335891943903`*^9}, {3.515011208637149*^9, 3.51501121389445*^9}, {
   3.515183070239438*^9, 3.5151830748102465`*^9}, {3.5151834311148725`*^9, 
   3.5151834353268795`*^9}, {3.516578772796842*^9, 3.516578781676854*^9}, {
   3.5168328444099736`*^9, 3.5168328499502907`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "1"}], "-", "6"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, 3.50448985016533*^9, {3.505355162817458*^9, 
   3.505355162817458*^9}, {3.513381577918584*^9, 3.5133815781185837`*^9}, 
   3.5133816428686743`*^9, {3.515183911715317*^9, 3.515183912245718*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 7 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.5018603533666525`*^9, 
   3.5018603814467015`*^9}, {3.5018631639043903`*^9, 3.5018631661195946`*^9}, 
   3.508786823233941*^9, {3.513387706167163*^9, 3.5133877066171637`*^9}, {
   3.5133974791450634`*^9, 3.513397480265065*^9}}],

Cell[TextData[{
 "Rule 1a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], ">", "1"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, 3.501860616180314*^9, {
   3.501860766919379*^9, 3.5018607678241806`*^9}, {3.5018636306572104`*^9, 
   3.501863632154813*^9}, {3.5019633694840164`*^9, 3.501963370514018*^9}, {
   3.5023182824802074`*^9, 3.5023182851790123`*^9}, {3.502329564622464*^9, 
   3.5023295733740797`*^9}, {3.5034412682015095`*^9, 3.503441273581517*^9}, {
   3.504489645915044*^9, 3.504489648125047*^9}, 3.50448967872509*^9, {
   3.505189326723132*^9, 3.505189331207389*^9}, {3.505189366105385*^9, 
   3.505189366105385*^9}, 3.5133878373073463`*^9, {3.513388224137888*^9, 
   3.5133882304378967`*^9}, {3.5137147401822023`*^9, 3.513714742927807*^9}, {
   3.513801750253065*^9, 3.513801751107114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "-", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"2", "j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "-", "3"}], "2"]}], ")"}]}], "-", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "-", "n", "+", 
          FractionBox[
           RowBox[{"k", "-", "3"}], "2"]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501860400993536*^9, 3.5018605059505205`*^9}, {3.5018605425013847`*^9, 
   3.5018605686782303`*^9}, 3.5033392142597537`*^9, {3.5048106354142704`*^9, 
   3.5048106376842737`*^9}, {3.5053551464874353`*^9, 3.505355162827458*^9}, 
   3.505355197907507*^9, 3.505363493643334*^9, 3.5133881491077833`*^9, {
   3.51339716233462*^9, 3.513397268864769*^9}, {3.51518391343132*^9, 
   3.515183916925726*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "3"}], ")"}], "/", "2"}]}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "-", "n", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, 3.5018203266692343`*^9, {3.5018204013465652`*^9, 
   3.5018204023137674`*^9}, 3.501860612342707*^9, {3.5018607334729204`*^9, 
   3.5018607601801677`*^9}, 3.5018608226738772`*^9, 3.5018782254037757`*^9, {
   3.5023182781434*^9, 3.5023182790326014`*^9}, {3.502328231709323*^9, 
   3.5023282353597293`*^9}, 3.503339217036558*^9, {3.503441249321483*^9, 
   3.5034412534214892`*^9}, {3.505187375919553*^9, 3.50518737622257*^9}, 
   3.505187511568311*^9, {3.505355146497435*^9, 3.505355162847458*^9}, 
   3.505355197917507*^9, 3.5053634954833364`*^9, 3.5133878856174145`*^9, {
   3.5133879841875525`*^9, 3.513387984837553*^9}, {3.5133880235676074`*^9, 
   3.5133880366976256`*^9}, 3.513388106307723*^9, 3.513397433294999*^9, 
   3.5134409156697893`*^9, {3.5137147466406136`*^9, 3.5137147486998167`*^9}, {
   3.5138017561114*^9, 3.5138017573564715`*^9}, {3.514002620461131*^9, 
   3.5140026297743473`*^9}, {3.5140067847540474`*^9, 
   3.5140067908536577`*^9}, {3.515971927587615*^9, 3.5159719342956266`*^9}, {
   3.515971967482885*^9, 3.5159719737228956`*^9}, 3.516820809136676*^9, 
   3.5168236558924203`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 7 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, 3.501814332956706*^9, 3.5087868232439413`*^9, {
   3.5133877168971777`*^9, 3.513387717377179*^9}, {3.5133931839869146`*^9, 
   3.513393184966916*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 12 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, {3.501880404136826*^9, 
   3.501880404716827*^9}, 3.5087868232439413`*^9, {3.5133877259171906`*^9, 
   3.513387726737192*^9}, {3.5133931781669064`*^9, 3.5133931795169086`*^9}}],

Cell[TextData[{
 "Rule 1b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"0", "<", 
       RowBox[{"j", " ", "k", " ", "m"}], "<", "1"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.5019852252072678`*^9, 3.5019852285472727`*^9}, {
   3.50205482983051*^9, 3.502054831110512*^9}, {3.504489651525052*^9, 
   3.5044896818350945`*^9}, {3.505189371841713*^9, 3.505189371841713*^9}, {
   3.51338783997735*^9, 3.513387844567357*^9}, 3.513388233827902*^9, {
   3.5137147643154445`*^9, 3.513714765937847*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.513392577705661*^9, 3.513392609975706*^9}, {
   3.513392694215824*^9, 3.513392704875839*^9}, {3.513392737255884*^9, 
   3.51339274112589*^9}, {3.5133931028868012`*^9, 3.513393163546886*^9}, {
   3.5151839301545496`*^9, 3.515183932619354*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"0", "<", 
     RowBox[{"j", "*", "k", "*", "m"}], "<", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018783882040033`*^9, 
   3.5018783932040105`*^9}, 3.501910304356453*^9, {3.5019850179769773`*^9, 
   3.5019850211269817`*^9}, {3.50198507709706*^9, 3.5019850837970695`*^9}, {
   3.501985197727229*^9, 3.5019851992872314`*^9}, {3.5020548244905024`*^9, 
   3.502054825820504*^9}, {3.5023202436376524`*^9, 3.502320247444059*^9}, {
   3.5023379615108128`*^9, 3.5023379654264197`*^9}, 3.5033390642030897`*^9, {
   3.505187411879609*^9, 3.505187412225629*^9}, 3.5051875191207433`*^9, {
   3.5053551465274353`*^9, 3.505355162877458*^9}, 3.505355197947507*^9, 
   3.505363500433344*^9, 3.5133878886374187`*^9, {3.5133879881275578`*^9, 
   3.5133879885875587`*^9}, 3.513388040607631*^9, 3.513388109027727*^9, 
   3.5133930839067745`*^9, {3.5133933124866967`*^9, 3.513393352116752*^9}, {
   3.513394105465011*^9, 3.5133941178350286`*^9}, 3.51344093298582*^9, {
   3.513714769151453*^9, 3.5137147711170564`*^9}, {3.5159719822873106`*^9, 
   3.5159719840501137`*^9}, 3.516820809176676*^9, 3.5168236559324226`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 8 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, 3.501878569854258*^9, 
   3.508786823253941*^9, {3.513387735967205*^9, 3.5133877365072055`*^9}, {
   3.5133974837550697`*^9, 3.5133974848950715`*^9}}],

Cell[TextData[{
 "Rule 2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "-", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], ">", "1"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "-", "1"}], "\[NotEqual]", 
       "n"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018083840990562`*^9, 
   3.5018084166251135`*^9}, {3.501878604894307*^9, 3.5018786057543077`*^9}, 
   3.5018790509349318`*^9, {3.50196172920172*^9, 3.5019617316817236`*^9}, {
   3.5020756982035265`*^9, 3.5020757010427313`*^9}, {3.502329414363*^9, 
   3.5023294176390057`*^9}, {3.502330219979615*^9, 3.502330219979615*^9}, {
   3.504489691225107*^9, 3.5044896917451077`*^9}, {3.5051719882429028`*^9, 
   3.505171990668041*^9}, {3.5051814360318103`*^9, 3.5051814425411825`*^9}, {
   3.5051814833155146`*^9, 3.5051814955322137`*^9}, {3.505189422808628*^9, 
   3.5051894301250467`*^9}, {3.5051953230271015`*^9, 3.5051953230271015`*^9}, 
   3.5133878489773626`*^9, {3.513388238217908*^9, 3.5133882398679104`*^9}, {
   3.5133971092245455`*^9, 3.5133971097845464`*^9}, {3.5136423391180477`*^9, 
   3.5136423588080754`*^9}, {3.5137147837686787`*^9, 3.513714809477524*^9}, {
   3.513801775616516*^9, 3.5138017764325624`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "-", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
       FractionBox[
        RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"2", "j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "-", "3"}], "2"]}], ")"}]}], "+", 
       RowBox[{"a", " ", "n", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018080658428974`*^9, 3.501808079789322*^9}, {3.5018081845435057`*^9, 
   3.501808206165144*^9}, {3.5018082365851974`*^9, 3.501808240376004*^9}, {
   3.501878579644272*^9, 3.5018785847742786`*^9}, {3.501878617764325*^9, 
   3.501878685154419*^9}, {3.50187872151447*^9, 3.5018787216944704`*^9}, {
   3.5048150181500144`*^9, 3.504815019540016*^9}, {3.505355146547435*^9, 
   3.505355162897458*^9}, 3.505355197957507*^9, 3.505363502953347*^9, 
   3.513388158437796*^9, {3.513396783114089*^9, 3.513396893424244*^9}, {
   3.515183944210174*^9, 3.515183948000981*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "3"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
           RowBox[{"a", "*", "n", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "n", "<", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "-", "1"}], "\[NotEqual]", 
     "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 3.5018079845979548`*^9}, 
   3.501808368327429*^9, {3.5018084216015224`*^9, 3.501808427217532*^9}, {
   3.501819528072632*^9, 3.50181953253424*^9}, {3.5018203432520638`*^9, 
   3.501820344032065*^9}, {3.5018786091343126`*^9, 3.501878610064314*^9}, 
   3.5018790581949415`*^9, {3.5018791385150537`*^9, 3.5018791568850794`*^9}, {
   3.5018793597353635`*^9, 3.5018793635253687`*^9}, 3.501910560680503*^9, 
   3.5019863481288395`*^9, {3.5020451897213154`*^9, 3.502045201858136*^9}, 
   3.5020756915891147`*^9, {3.502306962780834*^9, 3.502306963841636*^9}, {
   3.502307025726945*^9, 3.502307027099747*^9}, 3.5023072069680634`*^9, {
   3.5023278108049836`*^9, 3.502327815656592*^9}, {3.502327897057535*^9, 
   3.5023278984459376`*^9}, 3.502327932110797*^9, {3.5023282663881836`*^9, 
   3.502328267027785*^9}, {3.502330212132801*^9, 3.502330223318021*^9}, {
   3.505171983293619*^9, 3.5051719851817274`*^9}, {3.505181388258078*^9, 
   3.505181394954461*^9}, {3.50518148673571*^9, 3.5051815031006465`*^9}, {
   3.5051874256913996`*^9, 3.505187431983759*^9}, {3.5051897160734015`*^9, 
   3.5051897271320343`*^9}, {3.5051953059151225`*^9, 3.505195309785344*^9}, {
   3.5053551465674353`*^9, 3.5053551629074583`*^9}, 3.505355197967507*^9, 
   3.5053635049333496`*^9, 3.513387898807433*^9, {3.5133879921375637`*^9, 
   3.513387992567564*^9}, {3.513388051227646*^9, 3.5133880528176484`*^9}, 
   3.5133881119577312`*^9, 3.5133970539944687`*^9, {3.513397104734539*^9, 
   3.5133971058845406`*^9}, 3.5134409461990433`*^9, {3.513642274197957*^9, 
   3.513642291427981*^9}, {3.513714806388718*^9, 3.5137148128627295`*^9}, {
   3.513801780903818*^9, 3.5138017819748793`*^9}, 3.5140067363627625`*^9, {
   3.514006770246022*^9, 3.514006773974428*^9}, 3.516820809206676*^9, 
   3.516823655968425*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 9 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "a"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "b"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, {3.501808958164465*^9, 
   3.5018089598336678`*^9}, {3.5018887520990195`*^9, 3.5018887819590616`*^9}, 
   3.508786823253941*^9, {3.5133877456772184`*^9, 3.513387746207219*^9}, {
   3.513397486135073*^9, 3.5133974872850747`*^9}}],

Cell[TextData[{
 "Rule 3a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "-", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "1"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "2"}], " ", "\[And]",
       " ", 
      RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501812061374316*^9, 3.501812073838738*^9}, {
   3.5018891712996063`*^9, 3.5018891721496077`*^9}, 3.5018892149396677`*^9, {
   3.501889870350585*^9, 3.501889877930596*^9}, {3.5019616122915564`*^9, 
   3.5019616122915564`*^9}, {3.501963446484124*^9, 3.5019634484241266`*^9}, {
   3.5019854691076093`*^9, 3.5019854716876125`*^9}, {3.5019858450681353`*^9, 
   3.5019858450681353`*^9}, {3.50198626997873*^9, 3.501986271478732*^9}, 
   3.5021314533978634`*^9, {3.5023184824413586`*^9, 3.5023184926125765`*^9}, {
   3.502318577585926*^9, 3.50231858008193*^9}, {3.502329492721938*^9, 
   3.502329492721938*^9}, {3.50233161170686*^9, 3.5023316148268657`*^9}, {
   3.504489700745121*^9, 3.5044897024751234`*^9}, 3.505164492700603*^9, {
   3.5051648664611263`*^9, 3.5051648686311293`*^9}, {3.5051649653312645`*^9, 
   3.505164969751271*^9}, {3.505195341110135*^9, 3.505195341110135*^9}, 
   3.513387851927367*^9, {3.5133882448479176`*^9, 3.5133882461479187`*^9}, {
   3.513620775407731*^9, 3.513620794892165*^9}, {3.5136208894751315`*^9, 
   3.5136208900211325`*^9}, {3.513705598385437*^9, 3.5137056106314588`*^9}, {
   3.5137149153861094`*^9, 3.5137149168525124`*^9}, {3.513718474565963*^9, 
   3.513718481320775*^9}, {3.5138017891782913`*^9, 3.5138017901833487`*^9}, {
   3.5138254660577736`*^9, 3.5138254719621115`*^9}, {3.515009789725992*^9, 
   3.5150097981814756`*^9}, {3.51525440107832*^9, 3.515254404853526*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["b", "2"], 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "-", "2"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]}]], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "j", " ", "k", " ", "m"}], "+", "n", "+", "k"}], 
         ")"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "j", " ", "k", " ", "m"}], "+", 
          RowBox[{"3", " ", "n"}], "+", "k", "-", "3"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018085031116657`*^9, 3.5018086153694625`*^9}, {3.5018087435704875`*^9, 
   3.5018087487340965`*^9}, {3.501808975870496*^9, 3.5018090631370487`*^9}, {
   3.5018887937290783`*^9, 3.5018888537491617`*^9}, {3.501888888759211*^9, 
   3.501889055159444*^9}, {3.504810640684278*^9, 3.5048106424142804`*^9}, {
   3.5053551465874352`*^9, 3.505355162927458*^9}, 3.505355197987507*^9, 
   3.505363506753352*^9, 3.5133881630578027`*^9, {3.513396391369046*^9, 
   3.5133965080260515`*^9}, {3.515183950403385*^9, 3.515183952181788*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"b", "^", "2"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\n", "      ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "n", "+", 
              "k"}], ")"}]}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", 
              RowBox[{"3", "*", "n"}], "+", "k", "-", "3"}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.5018091789952526`*^9, 3.5018091989008875`*^9}, {
   3.501819685414508*^9, 3.501819688050913*^9}, {3.5018891469595723`*^9, 
   3.501889181499621*^9}, {3.5018898212705164`*^9, 3.5018898634705753`*^9}, {
   3.5019616089115515`*^9, 3.501961609351552*^9}, {3.5019633974840555`*^9, 
   3.501963422914091*^9}, {3.5019854228875446`*^9, 3.501985423087545*^9}, 
   3.5019858423081317`*^9, {3.5019862622087193`*^9, 3.5019862650687237`*^9}, {
   3.502040617764885*^9, 3.502040622304493*^9}, {3.5021314494666567`*^9, 
   3.5021314500906577`*^9}, {3.5023068614118567`*^9, 3.50230686351786*^9}, {
   3.5023070664274163`*^9, 3.502307067332218*^9}, {3.5023184596809187`*^9, 
   3.502318475889347*^9}, {3.502327270872435*^9, 3.50232727330604*^9}, {
   3.50232738749824*^9, 3.5023273916634474`*^9}, {3.502327723741231*^9, 
   3.5023277250984335`*^9}, 3.5023295095075674`*^9, 3.5023315749999957`*^9, {
   3.5051645117606297`*^9, 3.5051645140606327`*^9}, {3.505195347520502*^9, 
   3.505195350617679*^9}, {3.505355146597435*^9, 3.5053551629474583`*^9}, 
   3.505355197997507*^9, 3.5053635089433556`*^9, 3.5133879042274404`*^9, {
   3.513387995507568*^9, 3.513387995967569*^9}, {3.5133880563076534`*^9, 
   3.5133880579376554`*^9}, 3.513388114727735*^9, 3.5133967152239943`*^9, 
   3.5134409559022603`*^9, {3.5135728220521855`*^9, 3.5135728378862133`*^9}, {
   3.5136207369692636`*^9, 3.5136207424916735`*^9}, {3.5136208296178265`*^9, 
   3.513620872783102*^9}, {3.5137055788854027`*^9, 3.51370558278541*^9}, {
   3.5137056241098824`*^9, 3.513705626574687*^9}, {3.5137149014708853`*^9, 
   3.51371490412289*^9}, {3.5137184667815495`*^9, 3.5137185018504105`*^9}, {
   3.513793926254558*^9, 3.5137939433695374`*^9}, {3.51379422910288*^9, 
   3.5137942335621347`*^9}, {3.5137945411787295`*^9, 3.513794551781336*^9}, {
   3.5138017938705597`*^9, 3.5138017951256313`*^9}, {3.5138254798005595`*^9, 
   3.5138254884200525`*^9}, {3.5140023512826586`*^9, 3.514002371718694*^9}, {
   3.5140067460971794`*^9, 3.5140067610420055`*^9}, {3.51500977534717*^9, 
   3.5150097797294207`*^9}, {3.5159720120053625`*^9, 3.515972013955366*^9}, 
   3.516820809246676*^9, 3.516823656004427*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 8 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "a"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "b"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, 3.501814332956706*^9, {3.5051643755004387`*^9, 
   3.505164375790439*^9}, 3.5051644080104847`*^9, 3.508786823263941*^9, {
   3.5133877565472336`*^9, 3.5133877570672345`*^9}, {3.5133974882750764`*^9, 
   3.5133974893950777`*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 9 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, {3.501808958164465*^9, 
   3.5018089598336678`*^9}, {3.5051643024203367`*^9, 3.5051643287603736`*^9}, 
   3.508786823263941*^9, {3.5133877628172426`*^9, 3.513387763427243*^9}, {
   3.513397490165079*^9, 3.5133974912250805`*^9}}],

Cell[TextData[{
 "Note: In the case ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]],
 ", this rule simplifies to rule 10."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, 3.5120642383523664`*^9, {3.5132784319350185`*^9, 
   3.5132784361650248`*^9}, {3.5137079232171216`*^9, 
   3.5137080163648853`*^9}, {3.515190891943336*^9, 3.515190892393337*^9}}],

Cell[TextData[{
 "Rule 3b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "1"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "2"}], " ", "\[And]",
       " ", 
      RowBox[{"0", "<", "n", "<", "1"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[NotEqual]", 
       FractionBox["1", "2"]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501812061374316*^9, 3.501812073838738*^9}, {
   3.5019719909841585`*^9, 3.501971995094164*^9}, {3.501972122124342*^9, 
   3.501972125344346*^9}, {3.501982915863229*^9, 3.501982938943261*^9}, {
   3.502133167175275*^9, 3.5021331678772755`*^9}, {3.5022171521154647`*^9, 
   3.5022171759991064`*^9}, {3.502305215081764*^9, 3.5023052196837726`*^9}, {
   3.502310462638873*^9, 3.502310474869294*^9}, {3.5044879131626177`*^9, 
   3.5044879135426188`*^9}, 3.5051640230099454`*^9, {3.5051642851303124`*^9, 
   3.505164286130314*^9}, {3.5051645737407165`*^9, 3.50516459092074*^9}, 
   3.5051648751311383`*^9, {3.50518973841968*^9, 3.50518973841968*^9}, {
   3.5051953636354237`*^9, 3.5051953636354237`*^9}, {3.505335202855875*^9, 
   3.505335202855875*^9}, 3.5133878550073714`*^9, {3.5133882492679234`*^9, 
   3.5133882509479256`*^9}, {3.5137056731719685`*^9, 
   3.5137056737335696`*^9}, {3.5137149266649294`*^9, 3.513714946289764*^9}, {
   3.5137215650149927`*^9, 3.513721573688608*^9}, {3.5138018016580057`*^9, 
   3.5138018024240494`*^9}, {3.515254473088046*^9, 3.515254476145652*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]}]], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          RowBox[{"2", "n"}], "+", 
          FractionBox[
           RowBox[{"k", "-", "3"}], "2"]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018085031116657`*^9, 3.5018086153694625`*^9}, {3.5018087435704875`*^9, 
   3.5018087487340965`*^9}, {3.501808975870496*^9, 3.5018090631370487`*^9}, {
   3.5048105575041614`*^9, 3.5048105595941644`*^9}, {3.5051640498299828`*^9, 
   3.505164141510111*^9}, {3.5053551466174355`*^9, 3.505355162957458*^9}, 
   3.5053551980075073`*^9, 3.505363510583358*^9, 3.5133881672878084`*^9, {
   3.51339593909999*^9, 3.513396092681407*^9}, {3.5151839551925936`*^9, 
   3.515183961588605*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{"2", "*", "n"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.5018091789952526`*^9, 3.5018091989008875`*^9}, {
   3.501819685414508*^9, 3.501819688050913*^9}, {3.501890085850887*^9, 
   3.5018900870308886`*^9}, {3.501971873003993*^9, 3.50197189934403*^9}, {
   3.5019724700148287`*^9, 3.5019724783748407`*^9}, {3.5019828227230988`*^9, 
   3.501982824323101*^9}, {3.501982949443276*^9, 3.501982954023282*^9}, 
   3.501983147063553*^9, {3.5021331624796667`*^9, 3.5021331634000683`*^9}, {
   3.5021450342962136`*^9, 3.5021450345562143`*^9}, {3.5021460196075935`*^9, 
   3.5021460254676013`*^9}, {3.502160944912696*^9, 3.5021609498427024`*^9}, {
   3.502160998802771*^9, 3.502161005912781*^9}, {3.502161106282922*^9, 
   3.5021611199329405`*^9}, 3.50216156218356*^9, {3.5021630630256605`*^9, 
   3.5021630666956663`*^9}, {3.5022030229890685`*^9, 3.502203023207469*^9}, {
   3.5022032960099487`*^9, 3.5022032995199547`*^9}, {3.5022033725748835`*^9, 
   3.5022033746808867`*^9}, {3.502297747154648*^9, 3.502297747716249*^9}, {
   3.502298151335758*^9, 3.5022981515385585`*^9}, {3.502298614406971*^9, 
   3.5022986186345787`*^9}, {3.5023051741004925`*^9, 3.502305177158098*^9}, {
   3.5023055534463587`*^9, 3.5023055536491594`*^9}, {3.502310434792824*^9, 
   3.502310444464841*^9}, {3.503442157050593*^9, 3.5034421651002073`*^9}, {
   3.505164254110269*^9, 3.5051642785203032`*^9}, {3.5051645409606705`*^9, 
   3.505164566820707*^9}, 3.505164744100955*^9, 3.505164907151183*^9, {
   3.5051897335304003`*^9, 3.505189734788472*^9}, {3.5051953664205832`*^9, 
   3.5051953722249155`*^9}, {3.505355146637435*^9, 3.505355162977458*^9}, 
   3.5053551980275073`*^9, 3.5053635127433605`*^9, 3.5133879160774565`*^9, {
   3.513387999157573*^9, 3.5133879996075735`*^9}, {3.5133880614976606`*^9, 
   3.513388063137663*^9}, 3.5133881172777386`*^9, 3.513396270770858*^9, 
   3.513440964139075*^9, {3.5137058245390344`*^9, 3.5137058268790383`*^9}, 
   3.513714939909353*^9, {3.5137215762782125`*^9, 3.5137215797102184`*^9}, {
   3.513801810559514*^9, 3.5138018117835846`*^9}, {3.515254462012027*^9, 
   3.5152544641336308`*^9}, {3.5159720312713966`*^9, 3.515972033580201*^9}, 
   3.516820809286676*^9, 3.5168236560494294`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 10 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "a"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "b"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501897999882035*^9, 3.5018980004280357`*^9}, 3.508786823273941*^9, {
   3.5133877723772554`*^9, 3.5133877743972583`*^9}, {3.5133974922150817`*^9, 
   3.513397493415084*^9}}],

Cell[TextData[{
 "Rule 4a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "<", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501881120717829*^9, 3.501881120717829*^9}, {
   3.50189801407806*^9, 3.5018980148268614`*^9}, 3.5018981130758333`*^9, {
   3.5018994443557725`*^9, 3.5018994447457733`*^9}, {3.5019584883171825`*^9, 
   3.5019584883171825`*^9}, {3.502044001046027*^9, 3.502044002106829*^9}, {
   3.502045300169509*^9, 3.5020453083751235`*^9}, {3.5023272286431613`*^9, 
   3.5023272286431613`*^9}, {3.5023303205997915`*^9, 
   3.5023303205997915`*^9}, {3.504489772195221*^9, 3.504489772495221*^9}, 
   3.5051687738680506`*^9, {3.5051690066913676`*^9, 3.5051690066913676`*^9}, 
   3.513387858337376*^9, 3.5133882545279307`*^9, {3.513714970267006*^9, 
   3.513714971905009*^9}, {3.515009997183858*^9, 3.515009997183858*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
         RowBox[{"n", "-", "2"}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "-", "n", "+", "k", "+", 
          "3"}], ")"}]}], "+", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "n", "+", "k"}], ")"}],
         " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5133951012864146`*^9, 3.513395436935285*^9}, {
   3.5133955737854767`*^9, 3.51339563336556*^9}, {3.51518396450581*^9, 
   3.5151839663310127`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "-", "n", "+", "k",
               "+", "3"}], ")"}]}], "+", 
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "j", "*", "k", "*", "m"}], "+", "n", "+", 
              "k"}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, {3.5018980188984685`*^9, 3.50189801985007*^9}, {
   3.5018993588676224`*^9, 3.5018993591016226`*^9}, {3.501899407617708*^9, 
   3.5018994162601233`*^9}, {3.5019584349071083`*^9, 3.501958435137108*^9}, 
   3.502043281447963*^9, {3.502043836886939*^9, 3.5020438378697405`*^9}, {
   3.5020440523233175`*^9, 3.502044053150119*^9}, {3.5020452897486906`*^9, 
   3.5020452909654927`*^9}, {3.5023272013119135`*^9, 3.5023272098607283`*^9}, 
   3.5023293759713326`*^9, {3.502330255532078*^9, 3.502330260882887*^9}, {
   3.505169008467469*^9, 3.5051690099755554`*^9}, {3.505355146667435*^9, 
   3.5053551630074577`*^9}, 3.5053551980475073`*^9, 3.505363517073367*^9, 
   3.5133879210874643`*^9, {3.5133880027075777`*^9, 3.513388003137579*^9}, 
   3.5133880665876675`*^9, 3.5133881203977427`*^9, 3.5133958374610467`*^9, 
   3.5134409700670853`*^9, {3.513714974962614*^9, 3.5137149768034177`*^9}, 
   3.5150099857292027`*^9, {3.515972043845019*^9, 3.5159720459978228`*^9}, 
   3.516820809316676*^9, 3.5168236560844316`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 10 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, 
   3.505168787344822*^9, 3.508786823273941*^9, {3.513387779837266*^9, 
   3.5133877813172684`*^9}, {3.513397494335085*^9, 3.513397495625087*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 11 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "a"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "b"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501897999882035*^9, 3.5018980004280357`*^9}, {3.505169157520994*^9, 
   3.505169158371043*^9}, 3.5087868232839413`*^9, {3.513387786257275*^9, 
   3.513387786917276*^9}, {3.5133974968350887`*^9, 3.51339749797509*^9}}],

Cell[TextData[{
 "Note: In the case ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]],
 ", this rule simplifies to rule 9b."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, 3.5120642383523664`*^9, {3.5132784319350185`*^9, 
   3.5132784361650248`*^9}, {3.5137079232171216`*^9, 
   3.5137080163648853`*^9}, {3.513721612111476*^9, 3.5137216125482764`*^9}, {
   3.51519097316345*^9, 3.515190974143451*^9}}],

Cell[TextData[{
 "Rule 4b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "<", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{"0", "<", "n", "<", "1"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[NotEqual]", 
       FractionBox["1", "2"]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.5011924479085164`*^9, 
   3.501192449768519*^9}, {3.5012672318508615`*^9, 3.5012672409508743`*^9}, {
   3.5018067804754405`*^9, 3.5018068133914986`*^9}, {3.501807130150055*^9, 
   3.5018071318504577`*^9}, {3.501881120717829*^9, 3.501881120717829*^9}, {
   3.5021392710587983`*^9, 3.5021392736016026`*^9}, {3.5044879378026524`*^9, 
   3.504487938732654*^9}, 3.5051687714869146`*^9, {3.505168968224167*^9, 
   3.5051689846621075`*^9}, {3.5051690332028837`*^9, 
   3.5051690572712603`*^9}, {3.505169410535466*^9, 3.5051694176248713`*^9}, {
   3.505169969828456*^9, 3.505169969828456*^9}, 3.513387862487382*^9, {
   3.513388257487935*^9, 3.5133882588079367`*^9}, {3.5136209592696543`*^9, 
   3.513620999455325*^9}, {3.513705874568322*^9, 3.513705880059532*^9}, {
   3.513714986662635*^9, 3.5137149919666443`*^9}, {3.5137169251436405`*^9, 
   3.513716929480448*^9}, {3.5137170296698246`*^9, 3.513717030699426*^9}, {
   3.5137216366815186`*^9, 3.5137216451679335`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "-", "n", "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}]}], "+", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5132794480664415`*^9, 3.513279496296509*^9}, {3.5132795860166345`*^9, 
   3.513279591746642*^9}, {3.5133932513666115`*^9, 3.513393288606663*^9}, {
   3.5133934258280563`*^9, 3.513393443328081*^9}, {3.5133935089881725`*^9, 
   3.5133935483782277`*^9}, {3.515183969139018*^9, 3.5151839707926207`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "-", "n", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.50119120053677*^9, {3.5011912580268507`*^9, 3.501191260026853*^9}, 
   3.501191906207758*^9, 3.501266112379294*^9, {3.501266934110444*^9, 
   3.5012669465204616`*^9}, 3.501267020310565*^9, {3.501807055254323*^9, 
   3.5018070667983437`*^9}, {3.501807109511218*^9, 3.501807112069623*^9}, {
   3.501807165546517*^9, 3.5018071672157197`*^9}, 3.5018077525787473`*^9, {
   3.5018811153078213`*^9, 3.501881117787825*^9}, {3.5018900729508686`*^9, 
   3.5018900741908703`*^9}, 3.502138462290577*^9, 3.5021386292576704`*^9, {
   3.5021392649747877`*^9, 3.50213926650359*^9}, {3.503442192618655*^9, 
   3.503442204771077*^9}, {3.505168832232389*^9, 3.505168832442401*^9}, 
   3.505168878548038*^9, {3.505168936712365*^9, 3.5051689618098*^9}, {
   3.5051690166859393`*^9, 3.5051690194700985`*^9}, {3.5051690633886104`*^9, 
   3.505169074151226*^9}, 3.505169398139757*^9, {3.505169965514209*^9, 
   3.505169966458263*^9}, {3.5053551466974354`*^9, 3.505355163037458*^9}, 
   3.505355198077507*^9, 3.505363521293373*^9, 3.5133879294774756`*^9, {
   3.5133880061275826`*^9, 3.5133880065375834`*^9}, {3.513388071207674*^9, 
   3.513388072967676*^9}, 3.5133881232577467`*^9, {3.513393712420858*^9, 
   3.5133937155908623`*^9}, {3.51339405449494*^9, 3.513394067624958*^9}, 
   3.513440975215094*^9, {3.513620661543131*^9, 3.513620707095211*^9}, {
   3.5136210225277653`*^9, 3.513621023463767*^9}, {3.51362473907189*^9, 
   3.513624779756761*^9}, {3.5136248108008156`*^9, 3.513624834840458*^9}, {
   3.513705849327478*^9, 3.51370585640989*^9}, 3.5137150127770805`*^9, {
   3.513716939854466*^9, 3.51371694216327*^9}, {3.513716989702554*^9, 
   3.513716991028557*^9}, {3.5137170338350315`*^9, 3.5137170349270334`*^9}, {
   3.5137216491147404`*^9, 3.513721652219146*^9}, {3.515972062050251*^9, 
   3.5159720637818537`*^9}, 3.5168208093666763`*^9, 3.516823656128434*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 11 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, 
   3.501815012259899*^9, 3.5087868232939415`*^9, {3.5133877913472824`*^9, 
   3.513387792007283*^9}, {3.513397499005091*^9, 3.513397500035093*^9}}],

Cell[TextData[{
 "Rule 5: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", 
        FractionBox[
         RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "0"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018152969603987`*^9, 
   3.5018152976624002`*^9}, {3.5019631527037125`*^9, 3.501963154183715*^9}, {
   3.5019697498310204`*^9, 3.5019697498310204`*^9}, {3.502045984589511*^9, 
   3.502045984589511*^9}, {3.502319396821365*^9, 3.5023194100189877`*^9}, {
   3.5023296064929376`*^9, 3.502329608474141*^9}, {3.5023339013540816`*^9, 
   3.5023339013540816`*^9}, {3.5044897774352283`*^9, 
   3.5044897786552296`*^9}, {3.505171398971198*^9, 3.5051714013203325`*^9}, {
   3.5051895180320745`*^9, 3.5051895180320745`*^9}, {3.5051895821767435`*^9, 
   3.505189597225604*^9}, 3.5133878665673876`*^9, 3.5133882652779455`*^9, {
   3.5137150560983567`*^9, 3.5137150560983567`*^9}, {3.513808993828374*^9, 
   3.5138090204088945`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", "n"}], "+", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.501815019950712*^9, 3.501815042773553*^9}, {3.504810650784292*^9, 
   3.504810652074294*^9}, {3.505355146717435*^9, 3.5053551630474577`*^9}, 
   3.5053551980875072`*^9, 3.5053635229733753`*^9, 3.5133881809878273`*^9, {
   3.513393762090927*^9, 3.5133938308270245`*^9}, {3.513393896327116*^9, 
   3.5133939132171392`*^9}, {3.5151839734914255`*^9, 3.5151839753010287`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "*", "n"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501815056251976*^9, 3.5018150914456377`*^9}, {3.501962084402217*^9, 
   3.5019620853222184`*^9}, 3.501963123453672*^9, {3.5019632157938013`*^9, 
   3.5019632266338167`*^9}, {3.5019697456010146`*^9, 
   3.5019697463110156`*^9}, {3.502045976461897*^9, 3.5020459805959044`*^9}, {
   3.502319372422922*^9, 3.502319379942135*^9}, {3.502328155378389*^9, 
   3.502328170448015*^9}, {3.502333890215662*^9, 3.502333891229664*^9}, {
   3.505171387161523*^9, 3.5051713874075365`*^9}, {3.50518747657731*^9, 
   3.5051874809385595`*^9}, {3.5053551467374353`*^9, 3.505355163067458*^9}, 
   3.505355198107507*^9, 3.505363525043378*^9, 3.5133879372874866`*^9, {
   3.5133880095075874`*^9, 3.5133880099475884`*^9}, 3.513388076437681*^9, 
   3.5133881266577516`*^9, 3.513394027856902*^9, 3.5134409776486983`*^9, 
   3.5137150631651692`*^9, {3.5138089687019367`*^9, 3.5138089886660786`*^9}, {
   3.513964720348965*^9, 3.513964724628971*^9}, {3.513965013199375*^9, 
   3.5139650155993786`*^9}, 3.516820809396676*^9, 3.516823656162436*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 12 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.5018084803824253`*^9, 3.501808481100027*^9}, 3.5018151793673925`*^9, 
   3.5087868232939415`*^9, {3.513387796477289*^9, 3.5133877972872906`*^9}, {
   3.5133975009950943`*^9, 3.5133975020150957`*^9}}],

Cell[TextData[{
 "Rule 6: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "<", "0"}], " ", "\[And]", " ", 
      RowBox[{"n", "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.50181529162519*^9, 3.5018152927015915`*^9}, {
   3.5019635541242747`*^9, 3.501963558874282*^9}, {3.5019652763866863`*^9, 
   3.5019652763866863`*^9}, {3.501985346137437*^9, 3.5019853551474495`*^9}, {
   3.5023187886386967`*^9, 3.502318789403098*^9}, {3.5023296895162835`*^9, 
   3.5023297015595045`*^9}, {3.5023316517677307`*^9, 
   3.5023316517677307`*^9}, {3.502333862822014*^9, 3.502333863555215*^9}, {
   3.5023886706912384`*^9, 3.5023886706912384`*^9}, {3.5044897842752376`*^9, 
   3.504489785155239*^9}, {3.5051895461906853`*^9, 3.5051895514119835`*^9}, 
   3.513387869507392*^9, 3.5133882701579523`*^9, {3.513705975188499*^9, 
   3.513705975188499*^9}, {3.5137150684067783`*^9, 3.513715069935581*^9}, {
   3.513717114783574*^9, 3.513717115891176*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          RowBox[{"2", "n"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}]}], "-", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.513292062852798*^9, 3.513292242867111*^9}, {
   3.5132923801169157`*^9, 3.5132923861569242`*^9}, {3.5133942235351763`*^9, 
   3.5133943581717653`*^9}, {3.515183978218234*^9, 3.515183979809437*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\n", "      ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{"2", "*", "n"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.501815185950604*^9, 3.501815193859818*^9}, 
   3.5018153663025208`*^9, {3.501963510624214*^9, 3.5019635224342303`*^9}, {
   3.5019853143173923`*^9, 3.501985331897417*^9}, {3.5023186901245236`*^9, 
   3.5023186995781403`*^9}, {3.502328108500306*^9, 3.5023281359095545`*^9}, {
   3.502329683447873*^9, 3.502329705787112*^9}, 3.502329766050018*^9, {
   3.5023316434061155`*^9, 3.5023316474465227`*^9}, {3.5023338521983953`*^9, 
   3.5023338551468005`*^9}, 3.502388666141232*^9, 3.5033390786331153`*^9, {
   3.5051874883769846`*^9, 3.505187491383157*^9}, 3.5051895386622543`*^9, {
   3.505355146767435*^9, 3.505355163097458*^9}, 3.505355198127507*^9, 
   3.5053635303733854`*^9, 3.5133879447774973`*^9, {3.513388013527593*^9, 
   3.513388014077594*^9}, 3.513388079607686*^9, 3.513388129147755*^9, 
   3.513394426691861*^9, 3.513440981923106*^9, {3.513705980289708*^9, 
   3.513705985921318*^9}, {3.5137150728839865`*^9, 3.51371507492759*^9}, {
   3.5137171197287827`*^9, 3.5137171207583847`*^9}, {3.515972096541911*^9, 
   3.5159720985543146`*^9}, 3.5168208094266768`*^9, 3.5168236561984377`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for (sin^j)^m (a+a sin^k)^n", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.4000000953674316`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 3223, 69, 158, "Title"],
Cell[CellGroupData[{
Cell[3793, 93, 2041, 37, 55, "Subsubtitle"],
Cell[5837, 132, 9840, 185, 530, "Input"],
Cell[15680, 319, 1554, 26, 278, "Text"],
Cell[17237, 347, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[17318, 353, 3072, 63, 120, "Title"],
Cell[CellGroupData[{
Cell[20415, 420, 2310, 56, 1050, "Subsubtitle"],
Cell[22728, 478, 467, 6, 3823, "Subsubsection"],
Cell[23198, 486, 2824, 47, 2802, "Subsubsection"],
Cell[26025, 535, 1163, 22, 2802, "Subsubsection"],
Cell[27191, 559, 1570, 38, 6778, "Subsubtitle"],
Cell[28764, 599, 771, 11, 3823, "Subsubsection"],
Cell[29538, 612, 1542, 44, 11446, "Code"],
Cell[31083, 658, 470, 6, 3823, "Subsubsection"],
Cell[31556, 666, 1391, 41, 11446, "Code"],
Cell[32950, 709, 89, 2, 3823, "Subsubsection"],
Cell[33042, 713, 518, 7, 2731, "Subsubsection"],
Cell[33563, 722, 1206, 27, 4219, "Subsubsection"],
Cell[34772, 751, 1025, 19, 2802, "Subsubsection"],
Cell[35800, 772, 1576, 27, 2802, "Subsubsection"],
Cell[37379, 801, 2470, 52, 6778, "Subsubtitle"],
Cell[39852, 855, 771, 11, 3823, "Subsubsection"],
Cell[40626, 868, 2268, 58, 11446, "Code"],
Cell[42897, 928, 44, 1, 309, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[42978, 934, 2255, 56, 996, "Subsubtitle"],
Cell[45236, 992, 2781, 46, 946, "Subsubsection"],
Cell[48020, 1040, 1172, 22, 522, "Subsubsection"],
Cell[49195, 1064, 1538, 38, 1401, "Subsubtitle"],
Cell[50736, 1104, 771, 11, 712, "Subsubsection"],
Cell[51510, 1117, 1508, 43, 2129, "Code"],
Cell[53021, 1162, 1367, 40, 2328, "Code"],
Cell[54391, 1204, 89, 2, 712, "Subsubsection"],
Cell[54483, 1208, 491, 7, 509, "Subsubsection"],
Cell[54977, 1217, 1174, 22, 522, "Subsubsection"],
Cell[56154, 1241, 1709, 43, 1549, "Subsubtitle"],
Cell[57866, 1286, 771, 11, 712, "Subsubsection"],
Cell[58640, 1299, 1857, 52, 2129, "Code"],
Cell[60500, 1353, 44, 1, 58, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[60581, 1359, 2250, 56, 1114, "Subsubtitle"],
Cell[62834, 1417, 1274, 20, 712, "Subsubsection"],
Cell[64111, 1439, 1323, 23, 522, "Subsubsection"],
Cell[65437, 1464, 2243, 50, 1401, "Subsubtitle"],
Cell[67683, 1516, 771, 11, 712, "Subsubsection"],
Cell[68457, 1529, 1915, 52, 2129, "Code"],
Cell[70375, 1583, 89, 2, 712, "Subsubsection"],
Cell[70467, 1587, 1220, 19, 509, "Subsubsection"],
Cell[71690, 1608, 1326, 23, 522, "Subsubsection"],
Cell[73019, 1633, 2272, 51, 1401, "Subsubtitle"],
Cell[75294, 1686, 771, 11, 712, "Subsubsection"],
Cell[76068, 1699, 1904, 53, 2129, "Code"],
Cell[77975, 1754, 89, 2, 712, "Subsubsection"],
Cell[78067, 1758, 1323, 24, 522, "Subsubsection"],
Cell[79393, 1784, 2409, 57, 1401, "Subsubtitle"],
Cell[81805, 1843, 771, 11, 712, "Subsubsection"],
Cell[82579, 1856, 2306, 64, 2129, "Code"],
Cell[84888, 1922, 44, 1, 58, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[84969, 1928, 2055, 48, 926, "Subsubtitle"],
Cell[87027, 1978, 1677, 29, 522, "Subsubsection"],
Cell[88707, 2009, 3382, 53, 373, "Subsubsection"],
Cell[92092, 2064, 4940, 106, 1814, "Subsubtitle"],
Cell[97035, 2172, 821, 11, 509, "Subsubsection"],
Cell[97859, 2185, 5469, 127, 1887, "Code"],
Cell[103331, 2314, 89, 2, 509, "Subsubsection"],
Cell[103423, 2318, 1698, 29, 373, "Subsubsection"],
Cell[105124, 2349, 3471, 54, 373, "Subsubsection"],
Cell[108598, 2405, 5175, 107, 1731, "Subsubtitle"],
Cell[113776, 2514, 821, 11, 509, "Subsubsection"],
Cell[114600, 2527, 5906, 131, 1887, "Code"],
Cell[120509, 2660, 44, 1, 42, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[120602, 2667, 3251, 70, 120, "Title"],
Cell[CellGroupData[{
Cell[123878, 2741, 2829, 65, 112, "Subsubtitle"],
Cell[126710, 2808, 317, 6, 996, "Subsubsection"],
Cell[127030, 2816, 999, 28, 1430, "Subsubsection"],
Cell[128032, 2846, 1035, 27, 1134, "Subsubsection"],
Cell[129070, 2875, 1268, 19, 712, "Subsubsection"],
Cell[130341, 2896, 1297, 22, 730, "Subsubsection"],
Cell[131641, 2920, 4041, 94, 4858, "Subsubtitle"],
Cell[135685, 3016, 771, 11, 996, "Subsubsection"],
Cell[136459, 3029, 2470, 63, 2980, "Code"],
Cell[138932, 3094, 89, 2, 996, "Subsubsection"],
Cell[139024, 3098, 317, 6, 712, "Subsubsection"],
Cell[139344, 3106, 945, 27, 1430, "Subsubsection"],
Cell[140292, 3135, 1083, 27, 1134, "Subsubsection"],
Cell[141378, 3164, 1268, 19, 712, "Subsubsection"],
Cell[142649, 3185, 1268, 22, 730, "Subsubsection"],
Cell[143920, 3209, 3998, 94, 4858, "Subsubtitle"],
Cell[147921, 3305, 771, 11, 996, "Subsubsection"],
Cell[148695, 3318, 2396, 62, 2980, "Code"],
Cell[151094, 3382, 89, 2, 996, "Subsubsection"],
Cell[151186, 3386, 317, 6, 712, "Subsubsection"],
Cell[151506, 3394, 1401, 25, 730, "Subsubsection"],
Cell[152910, 3421, 3487, 76, 2431, "Subsubtitle"],
Cell[156400, 3499, 771, 11, 996, "Subsubsection"],
Cell[157174, 3512, 2735, 74, 3697, "Code"],
Cell[159912, 3588, 44, 1, 81, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[159993, 3594, 2622, 66, 138, "Subsubtitle"],
Cell[162618, 3662, 491, 7, 996, "Subsubsection"],
Cell[163112, 3671, 993, 13, 712, "Subsubsection"],
Cell[164108, 3686, 2282, 56, 1881, "Subsubsection"],
Cell[166393, 3744, 1590, 29, 996, "Subsubsection"],
Cell[167986, 3775, 3651, 87, 2583, "Subsubtitle"],
Cell[171640, 3864, 771, 11, 996, "Subsubsection"],
Cell[172414, 3877, 2675, 70, 3697, "Code"],
Cell[175092, 3949, 2712, 74, 3985, "Code"],
Cell[177807, 4025, 44, 1, 81, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[177888, 4031, 3078, 70, 107, "Subsubtitle"],
Cell[180969, 4103, 587, 14, 996, "Subsubsection"],
Cell[181559, 4119, 2318, 36, 730, "Subsubsection"],
Cell[183880, 4157, 2671, 42, 730, "Subsubsection"],
Cell[186554, 4201, 3883, 73, 2168, "Subsubtitle"],
Cell[190440, 4276, 821, 11, 996, "Subsubsection"],
Cell[191264, 4289, 3569, 73, 2980, "Code"],
Cell[194836, 4364, 3585, 73, 3259, "Code"],
Cell[198424, 4439, 89, 2, 996, "Subsubsection"],
Cell[198516, 4443, 426, 6, 712, "Subsubsection"],
Cell[198945, 4451, 313, 5, 712, "Subsubsection"],
Cell[199261, 4458, 2813, 44, 730, "Subsubsection"],
Cell[202077, 4504, 4177, 86, 2168, "Subsubtitle"],
Cell[206257, 4592, 821, 11, 996, "Subsubsection"],
Cell[207081, 4605, 4191, 92, 2980, "Code"],
Cell[211275, 4699, 44, 1, 81, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[211356, 4705, 3022, 69, 123, "Subsubtitle"],
Cell[214381, 4776, 426, 6, 996, "Subsubsection"],
Cell[214810, 4784, 313, 5, 712, "Subsubsection"],
Cell[215126, 4791, 2381, 38, 730, "Subsubsection"],
Cell[217510, 4831, 4251, 84, 2168, "Subsubtitle"],
Cell[221764, 4917, 821, 11, 996, "Subsubsection"],
Cell[222588, 4930, 3667, 79, 2980, "Code"],
Cell[226258, 5011, 44, 1, 81, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[226339, 5017, 2830, 66, 123, "Subsubtitle"],
Cell[229172, 5085, 277, 4, 996, "Subsubsection"],
Cell[229452, 5091, 896, 28, 1296, "Subsubsection"],
Cell[230351, 5121, 2378, 38, 730, "Subsubsection"],
Cell[232732, 5161, 4636, 96, 2168, "Subsubtitle"],
Cell[237371, 5259, 821, 11, 996, "Subsubsection"],
Cell[238195, 5272, 4255, 94, 3697, "Code"],
Cell[242453, 5368, 44, 1, 81, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[242534, 5374, 3429, 77, 128, "Subsubtitle"],
Cell[245966, 5453, 1720, 30, 191, "Subsubsection"],
Cell[247689, 5485, 2761, 49, 186, "Subsubsection"],
Cell[250453, 5536, 6798, 127, 401, "Subsubtitle"],
Cell[257254, 5665, 821, 11, 186, "Subsubsection"],
Cell[258078, 5678, 5266, 119, 824, "Code"],
Cell[263347, 5799, 89, 2, 186, "Subsubsection"],
Cell[263439, 5803, 1597, 26, 137, "Subsubsection"],
Cell[265039, 5831, 1686, 27, 137, "Subsubsection"],
Cell[266728, 5860, 2962, 54, 186, "Subsubsection"],
Cell[269693, 5916, 7005, 137, 634, "Subsubtitle"],
Cell[276701, 6055, 821, 11, 186, "Subsubsection"],
Cell[277525, 6068, 6092, 143, 824, "Code"],
Cell[283620, 6213, 44, 1, 16, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[283701, 6219, 2712, 48, 89, "Subsubtitle"],
Cell[286416, 6269, 625, 16, 1394, "Subsubsection"],
Cell[287044, 6287, 2404, 39, 730, "Subsubsection"],
Cell[289451, 6328, 3007, 60, 1804, "Subsubtitle"],
Cell[292461, 6390, 821, 11, 996, "Subsubsection"],
Cell[293285, 6403, 3547, 76, 2980, "Code"],
Cell[296835, 6481, 89, 2, 996, "Subsubsection"],
Cell[296927, 6485, 1402, 30, 1036, "Subsubsection"],
Cell[298332, 6517, 2083, 34, 730, "Subsubsection"],
Cell[300418, 6553, 4358, 78, 1961, "Subsubtitle"],
Cell[304779, 6633, 771, 11, 996, "Subsubsection"],
Cell[305553, 6646, 3245, 72, 2980, "Code"],
Cell[308801, 6720, 89, 2, 996, "Subsubsection"],
Cell[308893, 6724, 491, 7, 712, "Subsubsection"],
Cell[309387, 6733, 1470, 26, 730, "Subsubsection"],
Cell[310860, 6761, 2955, 64, 2168, "Subsubtitle"],
Cell[313818, 6827, 771, 11, 996, "Subsubsection"],
Cell[314592, 6840, 2689, 69, 2980, "Code"],
Cell[317284, 6911, 44, 1, 81, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[317365, 6917, 2718, 49, 89, "Subsubtitle"],
Cell[320086, 6968, 1607, 29, 1022, "Subsubsection"],
Cell[321696, 6999, 2506, 42, 730, "Subsubsection"],
Cell[324205, 7043, 4876, 100, 3245, "Subsubtitle"],
Cell[329084, 7145, 818, 11, 996, "Subsubsection"],
Cell[329905, 7158, 6421, 137, 3697, "Code"],
Cell[336329, 7297, 89, 2, 996, "Subsubsection"],
Cell[336421, 7301, 1558, 29, 730, "Subsubsection"],
Cell[337982, 7332, 2548, 43, 730, "Subsubsection"],
Cell[340533, 7377, 4646, 95, 3245, "Subsubtitle"],
Cell[345182, 7474, 818, 11, 996, "Subsubsection"],
Cell[346003, 7487, 6347, 135, 3697, "Code"],
Cell[352353, 7624, 44, 1, 81, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[352434, 7630, 2749, 52, 89, "Subsubtitle"],
Cell[355186, 7684, 993, 13, 186, "Subsubsection"],
Cell[356182, 7699, 1434, 35, 242, "Subsubsection"],
Cell[357619, 7736, 2392, 42, 186, "Subsubsection"],
Cell[360014, 7780, 5385, 110, 404, "Subsubtitle"],
Cell[365402, 7892, 821, 11, 186, "Subsubsection"],
Cell[366226, 7905, 7346, 151, 688, "Code"],
Cell[373575, 8058, 89, 2, 186, "Subsubsection"],
Cell[373667, 8062, 1411, 30, 193, "Subsubsection"],
Cell[375081, 8094, 2425, 42, 186, "Subsubsection"],
Cell[377509, 8138, 5161, 108, 819, "Subsubtitle"],
Cell[382673, 8248, 821, 11, 186, "Subsubsection"],
Cell[383497, 8261, 7578, 153, 688, "Code"],
Cell[391078, 8416, 89, 2, 186, "Subsubsection"],
Cell[391170, 8420, 1578, 32, 193, "Subsubsection"],
Cell[392751, 8454, 2267, 40, 186, "Subsubsection"],
Cell[395021, 8496, 5855, 116, 810, "Subsubtitle"],
Cell[400879, 8614, 771, 11, 186, "Subsubsection"],
Cell[401653, 8627, 5652, 127, 688, "Code"],
Cell[407308, 8756, 89, 2, 186, "Subsubsection"],
Cell[407400, 8760, 955, 13, 133, "Subsubsection"],
Cell[408358, 8775, 1205, 30, 281, "Subsubsection"],
Cell[409566, 8807, 2610, 47, 186, "Subsubsection"],
Cell[412179, 8856, 4993, 105, 809, "Subsubtitle"],
Cell[417175, 8963, 821, 11, 186, "Subsubsection"],
Cell[417999, 8976, 7630, 153, 688, "Code"],
Cell[425632, 9131, 44, 1, 16, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[425713, 9137, 2787, 51, 89, "Subsubtitle"],
Cell[428503, 9190, 993, 13, 2842, "Subsubsection"],
Cell[429499, 9205, 1685, 43, 3823, "Subsubsection"],
Cell[431187, 9250, 2233, 36, 2318, "Subsubsection"],
Cell[433423, 9288, 5204, 102, 10544, "Subsubtitle"],
Cell[438630, 9392, 821, 11, 2842, "Subsubsection"],
Cell[439454, 9405, 6858, 135, 11149, "Code"],
Cell[446315, 9542, 89, 2, 2842, "Subsubsection"],
Cell[446407, 9546, 955, 13, 2221, "Subsubsection"],
Cell[447365, 9561, 964, 23, 4138, "Subsubsection"],
Cell[448332, 9586, 3208, 51, 2842, "Subsubsection"],
Cell[451543, 9639, 5110, 96, 9193, "Subsubtitle"],
Cell[456656, 9737, 771, 11, 2842, "Subsubsection"],
Cell[457430, 9750, 6503, 124, 8940, "Code"],
Cell[463936, 9876, 44, 1, 309, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[464017, 9882, 2706, 61, 95, "Subsubtitle"],
Cell[466726, 9945, 1422, 24, 91, "Subsubsection"],
Cell[468151, 9971, 2604, 47, 89, "Subsubsection"],
Cell[470758, 10020, 4371, 86, 208, "Subsubtitle"],
Cell[475132, 10108, 771, 11, 89, "Subsubsection"],
Cell[475906, 10121, 4431, 98, 264, "Code"],
Cell[480340, 10221, 89, 2, 89, "Subsubsection"],
Cell[480432, 10225, 1564, 25, 95, "Subsubsection"],
Cell[481999, 10252, 2791, 51, 89, "Subsubsection"],
Cell[484793, 10305, 5977, 124, 393, "Subsubtitle"],
Cell[490773, 10431, 819, 11, 89, "Subsubsection"],
Cell[491595, 10444, 5918, 140, 392, "Code"],
Cell[497516, 10586, 89, 2, 89, "Subsubsection"],
Cell[497608, 10590, 1512, 24, 95, "Subsubsection"],
Cell[499123, 10616, 3014, 56, 89, "Subsubsection"],
Cell[502140, 10674, 5820, 122, 392, "Subsubtitle"],
Cell[507963, 10798, 819, 11, 89, "Subsubsection"],
Cell[508785, 10811, 6108, 142, 392, "Code"],
Cell[514896, 10955, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[514977, 10961, 3006, 68, 134, "Subsubtitle"],
Cell[517986, 11031, 1582, 27, 127, "Subsubsection"],
Cell[519571, 11060, 3389, 60, 105, "Subsubsection"],
Cell[522963, 11122, 5548, 118, 329, "Subsubtitle"],
Cell[528514, 11242, 821, 11, 95, "Subsubsection"],
Cell[529338, 11255, 6264, 147, 421, "Code"],
Cell[535605, 11404, 89, 2, 95, "Subsubsection"],
Cell[535697, 11408, 1585, 27, 99, "Subsubsection"],
Cell[537285, 11437, 3601, 66, 105, "Subsubsection"],
Cell[540889, 11505, 5173, 113, 329, "Subsubtitle"],
Cell[546065, 11620, 821, 11, 95, "Subsubsection"],
Cell[546889, 11633, 6423, 151, 421, "Code"],
Cell[553315, 11786, 44, 1, 9, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[553396, 11792, 3134, 70, 134, "Subsubtitle"],
Cell[556533, 11864, 1425, 25, 127, "Subsubsection"],
Cell[557961, 11891, 3711, 65, 105, "Subsubsection"],
Cell[561675, 11958, 5751, 120, 323, "Subsubtitle"],
Cell[567429, 12080, 771, 11, 95, "Subsubsection"],
Cell[568203, 12093, 6821, 153, 421, "Code"],
Cell[575027, 12248, 89, 2, 95, "Subsubsection"],
Cell[575119, 12252, 1507, 26, 99, "Subsubsection"],
Cell[576629, 12280, 3306, 62, 105, "Subsubsection"],
Cell[579938, 12344, 6695, 133, 324, "Subsubtitle"],
Cell[586636, 12479, 821, 11, 95, "Subsubsection"],
Cell[587460, 12492, 6388, 150, 421, "Code"],
Cell[593851, 12644, 44, 1, 9, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[593932, 12650, 3281, 69, 89, "Subsubtitle"],
Cell[597216, 12721, 702, 10, 95, "Subsubsection"],
Cell[597921, 12733, 2819, 43, 99, "Subsubsection"],
Cell[600743, 12778, 1803, 34, 95, "Subsubsection"],
Cell[602549, 12814, 3804, 93, 407, "Subsubtitle"],
Cell[606356, 12909, 771, 11, 95, "Subsubsection"],
Cell[607130, 12922, 2908, 79, 352, "Code"],
Cell[610041, 13003, 4549, 111, 379, "Code"],
Cell[614593, 13116, 89, 2, 95, "Subsubsection"],
Cell[614685, 13120, 1099, 15, 68, "Subsubsection"],
Cell[615787, 13137, 2723, 42, 99, "Subsubsection"],
Cell[618513, 13181, 2151, 39, 105, "Subsubsection"],
Cell[620667, 13222, 3429, 87, 401, "Subsubtitle"],
Cell[624099, 13311, 771, 11, 95, "Subsubsection"],
Cell[624873, 13324, 2846, 76, 352, "Code"],
Cell[627722, 13402, 4798, 114, 379, "Code"],
Cell[632523, 13518, 44, 1, 9, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[632604, 13524, 2586, 59, 89, "Subsubtitle"],
Cell[635193, 13585, 1507, 29, 1022, "Subsubsection"],
Cell[636703, 13616, 2922, 51, 996, "Subsubsection"],
Cell[639628, 13669, 5819, 135, 5083, "Subsubtitle"],
Cell[645450, 13806, 821, 11, 996, "Subsubsection"],
Cell[646274, 13819, 6678, 163, 5875, "Code"],
Cell[652955, 13984, 89, 2, 996, "Subsubsection"],
Cell[653047, 13988, 1352, 24, 730, "Subsubsection"],
Cell[654402, 14014, 1554, 29, 730, "Subsubsection"],
Cell[655959, 14045, 2631, 47, 996, "Subsubsection"],
Cell[658593, 14094, 7333, 153, 5062, "Subsubtitle"],
Cell[665929, 14249, 821, 11, 996, "Subsubsection"],
Cell[666753, 14262, 6531, 158, 5875, "Code"],
Cell[673287, 14422, 89, 2, 996, "Subsubsection"],
Cell[673379, 14426, 1527, 29, 730, "Subsubsection"],
Cell[674909, 14457, 3561, 65, 1099, "Subsubsection"],
Cell[678473, 14524, 6078, 136, 6092, "Subsubtitle"],
Cell[684554, 14662, 821, 11, 996, "Subsubsection"],
Cell[685378, 14675, 7621, 179, 5160, "Code"],
Cell[693002, 14856, 89, 2, 2842, "Subsubsection"],
Cell[693094, 14860, 1605, 30, 2318, "Subsubsection"],
Cell[694702, 14892, 4272, 75, 3109, "Subsubsection"],
Cell[698977, 14969, 6140, 136, 15895, "Subsubtitle"],
Cell[705120, 15107, 821, 11, 2842, "Subsubsection"],
Cell[705944, 15120, 8289, 187, 17862, "Code"],
Cell[714236, 15309, 89, 2, 2842, "Subsubsection"],
Cell[714328, 15313, 1505, 29, 2318, "Subsubsection"],
Cell[715836, 15344, 1605, 30, 2318, "Subsubsection"],
Cell[717444, 15376, 1853, 30, 2842, "Subsubsection"],
Cell[719300, 15408, 3739, 65, 3109, "Subsubsection"],
Cell[723042, 15475, 6123, 138, 16205, "Subsubtitle"],
Cell[729168, 15615, 821, 11, 2842, "Subsubsection"],
Cell[729992, 15628, 8210, 185, 17862, "Code"],
Cell[738205, 15815, 89, 2, 2842, "Subsubsection"],
Cell[738297, 15819, 1350, 27, 2318, "Subsubsection"],
Cell[739650, 15848, 3062, 53, 2842, "Subsubsection"],
Cell[742715, 15903, 6349, 140, 15895, "Subsubtitle"],
Cell[749067, 16045, 771, 11, 2842, "Subsubsection"],
Cell[749841, 16058, 6853, 164, 17862, "Code"],
Cell[756697, 16224, 89, 2, 2842, "Subsubsection"],
Cell[756789, 16228, 1241, 22, 2318, "Subsubsection"],
Cell[758033, 16252, 1393, 27, 2318, "Subsubsection"],
Cell[759429, 16281, 1904, 31, 2842, "Subsubsection"],
Cell[761336, 16314, 3151, 55, 3109, "Subsubsection"],
Cell[764490, 16371, 6458, 141, 16205, "Subsubtitle"],
Cell[770951, 16514, 771, 11, 2842, "Subsubsection"],
Cell[771725, 16527, 7389, 173, 17862, "Code"],
Cell[779117, 16702, 89, 2, 2842, "Subsubsection"],
Cell[779209, 16706, 1399, 24, 2318, "Subsubsection"],
Cell[780611, 16732, 3250, 60, 1099, "Subsubsection"],
Cell[783864, 16794, 5842, 133, 6092, "Subsubtitle"],
Cell[789709, 16929, 821, 11, 996, "Subsubsection"],
Cell[790533, 16942, 6731, 165, 5160, "Code"],
Cell[797267, 17109, 89, 2, 996, "Subsubsection"],
Cell[797359, 17113, 1457, 25, 730, "Subsubsection"],
Cell[798819, 17140, 3138, 54, 996, "Subsubsection"],
Cell[801960, 17196, 5850, 134, 5083, "Subsubtitle"],
Cell[807813, 17332, 821, 11, 996, "Subsubsection"],
Cell[808637, 17345, 6727, 162, 5875, "Code"],
Cell[815367, 17509, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
